"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearch = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _saved_search_utils = require("../../index_data_visualizer/utils/saved_search_utils");
var _kibana_context = require("../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearch = ({
  dataView,
  savedSearch
}, appState, readOnly = false) => {
  const {
    uiSettings,
    data: {
      query: {
        filterManager
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)().services;
  (0, _react.useEffect)(function clearFiltersOnLeave() {
    return () => {
      // We want to clear all filters that have not been pinned globally
      // when navigating to other pages
      filterManager.getFilters().filter(f => {
        var _f$$state;
        return ((_f$$state = f.$state) === null || _f$$state === void 0 ? void 0 : _f$$state.store) === _esQuery.FilterStateStore.APP_STATE;
      }).forEach(f => filterManager.removeFilter(f));
    };
  }, [filterManager]);
  const searchData = (0, _saved_search_utils.getEsQueryFromSavedSearch)({
    dataView,
    uiSettings,
    savedSearch,
    filterManager
  });
  if (searchData === undefined || appState && appState.searchString !== '') {
    if (appState !== null && appState !== void 0 && appState.filters && readOnly === false) {
      const globalFilters = filterManager === null || filterManager === void 0 ? void 0 : filterManager.getGlobalFilters();
      if (filterManager) filterManager.setFilters(appState.filters);
      if (globalFilters) filterManager === null || filterManager === void 0 ? void 0 : filterManager.addFilters(globalFilters);
    }
    return {
      searchQuery: appState === null || appState === void 0 ? void 0 : appState.searchQuery,
      searchString: appState === null || appState === void 0 ? void 0 : appState.searchString,
      searchQueryLanguage: appState === null || appState === void 0 ? void 0 : appState.searchQueryLanguage
    };
  } else {
    return {
      searchQuery: searchData.searchQuery,
      searchString: searchData.searchString,
      searchQueryLanguage: searchData.queryLanguage
    };
  }
};
exports.useSearch = useSearch;