"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areLayoutsEqual = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Checks whether the layouts have the same keys, and if they do, checks whether every layout item in the
 * original layout is deep equal to the layout item at the same ID in the new layout
 */
const areLayoutsEqual = (originalLayout, newLayout) => {
  var _newLayout$sections, _originalLayout$secti, _newLayout$panels, _originalLayout$panel;
  /**
   * It is safe to assume that there are **usually** more panels than sections, so do cheaper section ID comparison first
   */
  const newSectionUuids = Object.keys((_newLayout$sections = newLayout === null || newLayout === void 0 ? void 0 : newLayout.sections) !== null && _newLayout$sections !== void 0 ? _newLayout$sections : {});
  const sectionIdDiff = (0, _lodash.xor)(Object.keys((_originalLayout$secti = originalLayout === null || originalLayout === void 0 ? void 0 : originalLayout.sections) !== null && _originalLayout$secti !== void 0 ? _originalLayout$secti : {}), newSectionUuids);
  if (sectionIdDiff.length > 0) return false;

  /**
   * Since section IDs are equal, check for more expensive panel ID equality
   */
  const newPanelUuids = Object.keys((_newLayout$panels = newLayout === null || newLayout === void 0 ? void 0 : newLayout.panels) !== null && _newLayout$panels !== void 0 ? _newLayout$panels : {});
  const panelIdDiff = (0, _lodash.xor)(Object.keys((_originalLayout$panel = originalLayout === null || originalLayout === void 0 ? void 0 : originalLayout.panels) !== null && _originalLayout$panel !== void 0 ? _originalLayout$panel : {}), newPanelUuids);
  if (panelIdDiff.length > 0) return false;

  /**
   * IDs of all widgets are equal, so now actually compare contents - this is the most expensive equality comparison step
   */
  // again, start with section comparison since it is most likely cheaper
  for (const sectionId of newSectionUuids) {
    if (!(0, _fastDeepEqual.default)(originalLayout === null || originalLayout === void 0 ? void 0 : originalLayout.sections[sectionId], newLayout === null || newLayout === void 0 ? void 0 : newLayout.sections[sectionId])) {
      return false;
    }
  }
  // then compare panel grid data
  for (const embeddableId of newPanelUuids) {
    var _originalLayout$panel2, _newLayout$panels$emb;
    if (!(0, _fastDeepEqual.default)(originalLayout === null || originalLayout === void 0 ? void 0 : (_originalLayout$panel2 = originalLayout.panels[embeddableId]) === null || _originalLayout$panel2 === void 0 ? void 0 : _originalLayout$panel2.gridData, newLayout === null || newLayout === void 0 ? void 0 : (_newLayout$panels$emb = newLayout.panels[embeddableId]) === null || _newLayout$panels$emb === void 0 ? void 0 : _newLayout$panels$emb.gridData)) {
      return false;
    }
  }
  return true;
};
exports.areLayoutsEqual = areLayoutsEqual;