"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkClusterRoutingAllocationEnabled = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ROUTING_ALLOCATION_ENABLE = 'cluster.routing.allocation.enable';
const checkClusterRoutingAllocationEnabled = client => () => {
  return client.cluster.getSettings({
    flat_settings: true
  }).then(settings => {
    var _settings$transient$R, _settings$transient, _settings$persistent;
    // transient settings take preference over persistent settings
    const clusterRoutingAllocation = (_settings$transient$R = settings === null || settings === void 0 ? void 0 : (_settings$transient = settings.transient) === null || _settings$transient === void 0 ? void 0 : _settings$transient[ROUTING_ALLOCATION_ENABLE]) !== null && _settings$transient$R !== void 0 ? _settings$transient$R : settings === null || settings === void 0 ? void 0 : (_settings$persistent = settings.persistent) === null || _settings$persistent === void 0 ? void 0 : _settings$persistent[ROUTING_ALLOCATION_ENABLE];
    const clusterRoutingAllocationEnabledIsAll = clusterRoutingAllocation === undefined || clusterRoutingAllocation === 'all';
    if (!clusterRoutingAllocationEnabledIsAll) {
      return Either.left({
        type: 'incompatible_cluster_routing_allocation'
      });
    } else {
      return Either.right({});
    }
  }).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.checkClusterRoutingAllocationEnabled = checkClusterRoutingAllocationEnabled;