"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCoreHandlers = void 0;
var _lifecycle_handlers = require("./lifecycle_handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerCoreHandlers = (registrar, config, env, log) => {
  // add headers based on config
  registrar.registerOnPreResponse((0, _lifecycle_handlers.createCustomHeadersPreResponseHandler)(config));
  // add extra request checks stuff
  registrar.registerOnPostAuth((0, _lifecycle_handlers.createXsrfPostAuthHandler)(config));
  if (config.versioned.strictClientVersionCheck !== false) {
    // add check on version
    registrar.registerOnPostAuth((0, _lifecycle_handlers.createVersionCheckPostAuthHandler)(env.packageInfo.version));
  } else {
    registrar.registerOnPreResponse((0, _lifecycle_handlers.createBuildNrMismatchLoggerPreResponseHandler)(env.packageInfo.buildNum, log));
  }
  // add check on header if the route is internal
  registrar.registerOnPostAuth((0, _lifecycle_handlers.createRestrictInternalRoutesPostAuthHandler)(config, log)); // strictly speaking, we should have access to route.options.access from the request on postAuth
};
exports.registerCoreHandlers = registerCoreHandlers;