"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _fields_selector = require("./fields_selector");
var _use_styles = require("./use_styles");
var _test_subjects = require("../test_subjects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupSelectorWrapper = ({
  children
}) => {
  const styles = (0, _use_styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: styles.groupBySelector
  }, children);
};
const AdditionalControls = ({
  total,
  title,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn,
  groupSelectorComponent,
  onResetColumns
}) => {
  const {
    isFieldSelectorModalVisible,
    closeFieldsSelectorModal,
    openFieldsSelectorModal
  } = (0, _fields_selector.useFieldsModal)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFieldSelectorModalVisible && /*#__PURE__*/_react.default.createElement(_fields_selector.FieldsSelectorModal, {
    columns: columns,
    dataView: dataView,
    closeModal: closeFieldsSelectorModal,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    onResetColumns: onResetColumns
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "cspDataTableTotal"
  }, `${(0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(total)} ${title}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    className: "cspDataTableFields",
    iconType: "tableOfContents",
    onClick: openFieldsSelectorModal,
    size: "xs",
    color: "text",
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_OPEN_BUTTON
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsButton",
    defaultMessage: "Fields"
  }))), groupSelectorComponent && /*#__PURE__*/_react.default.createElement(GroupSelectorWrapper, null, groupSelectorComponent));
};
exports.AdditionalControls = AdditionalControls;