"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeShapeSchema = exports.nodeBaseDataSchema = exports.labelNodeDataSchema = exports.groupNodeDataSchema = exports.graphResponseSchema = exports.graphRequestSchema = exports.entityNodeDataSchema = exports.edgeDataSchema = exports.colorSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../../types/graph/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphRequestSchema = exports.graphRequestSchema = _configSchema.schema.object({
  nodesLimit: _configSchema.schema.maybe(_configSchema.schema.number()),
  showUnknownTarget: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  query: _configSchema.schema.object({
    originEventIds: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      isAlert: _configSchema.schema.boolean()
    })),
    // TODO: use zod for range validation instead of config schema
    start: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    end: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    esQuery: _configSchema.schema.maybe(_configSchema.schema.object({
      bool: _configSchema.schema.object({
        filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })))
      })
    }))
  })
});
const graphResponseSchema = () => _configSchema.schema.object({
  nodes: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([entityNodeDataSchema, groupNodeDataSchema, labelNodeDataSchema])),
  edges: _configSchema.schema.arrayOf(edgeDataSchema),
  messages: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_v.ApiMessageCode.ReachedNodesLimit)])))
});
exports.graphResponseSchema = graphResponseSchema;
const colorSchema = exports.colorSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('primary'), _configSchema.schema.literal('danger'), _configSchema.schema.literal('warning')]);
const nodeShapeSchema = exports.nodeShapeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('hexagon'), _configSchema.schema.literal('pentagon'), _configSchema.schema.literal('ellipse'), _configSchema.schema.literal('rectangle'), _configSchema.schema.literal('diamond'), _configSchema.schema.literal('label'), _configSchema.schema.literal('group')]);
const nodeBaseDataSchema = exports.nodeBaseDataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  icon: _configSchema.schema.maybe(_configSchema.schema.string())
});
const entityNodeDataSchema = exports.entityNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  color: colorSchema,
  shape: _configSchema.schema.oneOf([_configSchema.schema.literal('hexagon'), _configSchema.schema.literal('pentagon'), _configSchema.schema.literal('ellipse'), _configSchema.schema.literal('rectangle'), _configSchema.schema.literal('diamond')])
})]);
const groupNodeDataSchema = exports.groupNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  shape: _configSchema.schema.literal('group')
})]);
const labelNodeDataSchema = exports.labelNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  shape: _configSchema.schema.literal('label'),
  parentId: _configSchema.schema.maybe(_configSchema.schema.string()),
  color: colorSchema
})]);
const edgeDataSchema = exports.edgeDataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  source: _configSchema.schema.string(),
  target: _configSchema.schema.string(),
  color: colorSchema,
  type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('solid'), _configSchema.schema.literal('dashed')]))
});