"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAuthorizationFilter = void 0;
var _apmUtils = require("@kbn/apm-utils");
var _audit_events = require("../common/audit_events");
var _constants = require("../common/constants");
var _types = require("../../authorization/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAuthorizationFilter = async (context, {
  action
}) => {
  try {
    const authorizationTuple = await (0, _apmUtils.withSpan)({
      name: 'authorization.getFindAuthorizationFilter',
      type: 'rules'
    }, () => context.authorization.getFindAuthorizationFilter({
      authorizationEntity: _types.AlertingAuthorizationEntity.Rule,
      filterOpts: _constants.alertingAuthorizationFilterOpts
    }));
    return authorizationTuple.filter;
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction[action],
      error
    }));
    throw error;
  }
};
exports.getAuthorizationFilter = getAuthorizationFilter;