"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSlightShadowHover = exports.euiShadowXSmall = exports.euiShadowXLarge = exports.euiShadowSmall = exports.euiShadowMedium = exports.euiShadowLarge = exports.euiShadowFlat = exports.euiShadow = void 0;
var _functions = require("../functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * euiSlightShadow
 */
var euiShadowXSmall = exports.euiShadowXSmall = function euiShadowXSmall(_ref, options) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode,
    highContrastMode = _ref.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  return "\nbox-shadow:\n  0 .8px .8px ".concat((0, _functions.getShadowColor)(color, 0.04, colorMode), ",\n  0 2.3px 2px ").concat((0, _functions.getShadowColor)(color, 0.03, colorMode), ";\n");
};

/**
 * bottomShadowSmall
 */
var euiShadowSmall = exports.euiShadowSmall = function euiShadowSmall(_ref2, options) {
  var euiTheme = _ref2.euiTheme,
    colorMode = _ref2.colorMode,
    highContrastMode = _ref2.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  return "\nbox-shadow:\n  0 .7px 1.4px ".concat((0, _functions.getShadowColor)(color, 0.07, colorMode), ",\n  0 1.9px 4px ").concat((0, _functions.getShadowColor)(color, 0.05, colorMode), ",\n  0 4.5px 10px ").concat((0, _functions.getShadowColor)(color, 0.05, colorMode), ";\n");
};

/**
 * bottomShadowMedium
 */
var euiShadowMedium = exports.euiShadowMedium = function euiShadowMedium(_ref3, options) {
  var euiTheme = _ref3.euiTheme,
    colorMode = _ref3.colorMode,
    highContrastMode = _ref3.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  if ((options === null || options === void 0 ? void 0 : options.property) === 'filter') {
    // Using only one drop-shadow filter instead of multiple is more performant & prevents Safari bugs
    return "filter: drop-shadow(0 5.7px 9px ".concat((0, _functions.getShadowColor)(color, 0.2, colorMode), ");");
  } else {
    return "box-shadow:\n      0 .9px 4px ".concat((0, _functions.getShadowColor)(color, 0.08, colorMode), ",\n      0 2.6px 8px ").concat((0, _functions.getShadowColor)(color, 0.06, colorMode), ",\n      0 5.7px 12px ").concat((0, _functions.getShadowColor)(color, 0.05, colorMode), ",\n      0 15px 15px ").concat((0, _functions.getShadowColor)(color, 0.04, colorMode), ";");
  }
};

/**
 * bottomShadow
 */
var euiShadowLarge = exports.euiShadowLarge = function euiShadowLarge(_ref4, options) {
  var euiTheme = _ref4.euiTheme,
    colorMode = _ref4.colorMode,
    highContrastMode = _ref4.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  return "\nbox-shadow:\n  0 1px 5px ".concat((0, _functions.getShadowColor)(color, 0.1, colorMode), ",\n  0 3.6px 13px ").concat((0, _functions.getShadowColor)(color, 0.07, colorMode), ",\n  0 8.4px 23px ").concat((0, _functions.getShadowColor)(color, 0.06, colorMode), ",\n  0 23px 35px ").concat((0, _functions.getShadowColor)(color, 0.05, colorMode), ";\n");
};

/**
 * bottomShadowLarge
 */

var euiShadowXLarge = exports.euiShadowXLarge = function euiShadowXLarge(_ref5, options) {
  var _options$reverse;
  var euiTheme = _ref5.euiTheme,
    colorMode = _ref5.colorMode,
    highContrastMode = _ref5.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  var reverse = (_options$reverse = options === null || options === void 0 ? void 0 : options.reverse) !== null && _options$reverse !== void 0 ? _options$reverse : false;
  return "\nbox-shadow:\n  0 ".concat(reverse ? '-' : '', "2.7px 9px ").concat((0, _functions.getShadowColor)(color, 0.13, colorMode), ",\n  0 ").concat(reverse ? '-' : '', "9.4px 24px ").concat((0, _functions.getShadowColor)(color, 0.09, colorMode), ",\n  0 ").concat(reverse ? '-' : '', "21.8px 43px ").concat((0, _functions.getShadowColor)(color, 0.08, colorMode), ";\n");
};

/**
 * slightShadowHover
 */
var euiSlightShadowHover = exports.euiSlightShadowHover = function euiSlightShadowHover(_ref6, options) {
  var euiTheme = _ref6.euiTheme,
    colorMode = _ref6.colorMode,
    highContrastMode = _ref6.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  return "\nbox-shadow:\n  0 1px 5px ".concat((0, _functions.getShadowColor)(color, 0.1, colorMode), ",\n  0 3.6px 13px ").concat((0, _functions.getShadowColor)(color, 0.07, colorMode), ",\n  0 8.4px 23px ").concat((0, _functions.getShadowColor)(color, 0.06, colorMode), ",\n  0 23px 35px ").concat((0, _functions.getShadowColor)(color, 0.05, colorMode), ";\n");
};

/**
 * bottomShadowFlat
 *
 * Similar to shadow medium but without the bottom depth.
 * Useful for popovers that drop UP rather than DOWN.
 */
var euiShadowFlat = exports.euiShadowFlat = function euiShadowFlat(_ref7, options) {
  var euiTheme = _ref7.euiTheme,
    colorMode = _ref7.colorMode,
    highContrastMode = _ref7.highContrastMode;
  if (highContrastMode) {
    return _highContrastBorder(euiTheme, options);
  }
  var color = (options === null || options === void 0 ? void 0 : options.color) || euiTheme.colors.shadow;
  return "\nbox-shadow:\n  0 0 .8px ".concat((0, _functions.getShadowColor)(color, 0.06, colorMode), ",\n  0 0 2px ").concat((0, _functions.getShadowColor)(color, 0.04, colorMode), ",\n  0 0 5px ").concat((0, _functions.getShadowColor)(color, 0.04, colorMode), ",\n  0 0 17px ").concat((0, _functions.getShadowColor)(color, 0.03, colorMode), ";\n");
};
var euiShadow = exports.euiShadow = function euiShadow(euiThemeContext) {
  var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'l';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  if (euiThemeContext.highContrastMode) {
    return _highContrastBorder(euiThemeContext.euiTheme, options);
  }
  switch (size) {
    case 'xs':
      return euiShadowXSmall(euiThemeContext, options);
    case 's':
      return euiShadowSmall(euiThemeContext, options);
    case 'm':
      return euiShadowMedium(euiThemeContext, options);
    case 'l':
      return euiShadowLarge(euiThemeContext, options);
    case 'xl':
      return euiShadowXLarge(euiThemeContext, options);
    default:
      console.warn('Please provide a valid size option to useEuiShadow');
      return '';
  }
};

/**
 * Internal utilities for replacing shadows with high contrast borders instead.
 * NOTE: Windows' high contrast themes ignore *all* `box-shadow` CSS,
 * so we use `border` CSS explicitly instead of shadows
 */

var _highContrastBorder = function _highContrastBorder(_ref8) {
  var border = _ref8.border;
  var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    borderAllInHighContrastMode = _ref9.borderAllInHighContrastMode;
  return borderAllInHighContrastMode ? "border: ".concat(border.thin, ";") : "border-block-end: ".concat(border.thin, ";");
};