"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassicStreamBadge = ClassicStreamBadge;
exports.DiscoverBadgeButton = DiscoverBadgeButton;
exports.LifecycleBadge = LifecycleBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/discover-plugin/common");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../hooks/use_kibana");
var _hierarchy_helpers = require("../../util/hierarchy_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataRetentionTooltip = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  title: _i18n.i18n.translate('xpack.streams.badges.lifecycle.title', {
    defaultMessage: 'Data Retention'
  }),
  content: _i18n.i18n.translate('xpack.streams.badges.lifecycle.description', {
    defaultMessage: 'You can edit retention settings from the stream’s management view'
  }),
  anchorProps: {
    css: (0, _react2.css)`
        display: inline-flex;
      `
  }
}, children);
function ClassicStreamBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: _i18n.i18n.translate('xpack.streams.badges.classic.title', {
      defaultMessage: 'Classic Stream'
    }),
    content: _i18n.i18n.translate('xpack.streams.badges.classic.description', {
      defaultMessage: 'Classic streams are based on existing data streams and may not support all Streams features like custom re-routing'
    }),
    anchorProps: {
      css: (0, _react2.css)`
          display: inline-flex;
        `
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.unmanagedBadgeLabel', {
    defaultMessage: 'Classic'
  })));
}
function LifecycleBadge({
  lifecycle
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  let badge;
  if ((0, _streamsSchema.isIlmLifecycle)(lifecycle)) {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "streamsAppLifecycleBadgeIlmPolicyNameLink",
      color: "text",
      target: "_blank",
      href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
        page: 'policy_edit',
        policyName: lifecycle.ilm.policy
      })
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.ilmBadgeLabel', {
      defaultMessage: 'ILM Policy: {name}',
      values: {
        name: lifecycle.ilm.policy
      }
    })));
  } else if ((0, _streamsSchema.isErrorLifecycle)(lifecycle)) {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.errorBadgeLabel', {
      defaultMessage: 'Error: {message}',
      values: {
        message: lifecycle.error.message
      }
    }));
  } else if ((0, _streamsSchema.isDslLifecycle)(lifecycle)) {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.dslBadgeLabel', {
      defaultMessage: 'Retention: {retention}',
      values: {
        retention: lifecycle.dsl.data_retention || '∞'
      }
    }));
  } else {
    badge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.disabledLifecycleBadgeLabel', {
      defaultMessage: 'Retention: Disabled'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(DataRetentionTooltip, null, badge);
}
function DiscoverBadgeButton({
  definition
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const discoverLocator = share.url.locators.get(_common.DISCOVER_APP_LOCATOR);
  const dataStreamExists = _streamsSchema.Streams.WiredStream.GetResponse.is(definition) || definition.data_stream_exists;
  const indexPatterns = (0, _hierarchy_helpers.getIndexPatterns)(definition.stream);
  const esqlQuery = indexPatterns ? `FROM ${indexPatterns.join(', ')}` : undefined;
  if (!discoverLocator || !dataStreamExists || !esqlQuery) {
    return null;
  }
  const discoverLink = discoverLocator.useUrl({
    query: {
      esql: esqlQuery
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsDetailOpenInDiscoverBadgeButton",
    href: discoverLink,
    iconType: "discoverApp",
    size: "xs",
    "aria-label": _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.openInDiscoverBadgeLabel', {
      defaultMessage: 'Open in Discover'
    })
  });
}