"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTemplateDetails = IndexTemplateDetails;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _managed_badge = require("./managed_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IndexTemplateDetails({
  indexTemplate,
  onFlyoutOpen
}) {
  var _indexTemplate$index_;
  const patterns = (_indexTemplate$index_ = indexTemplate === null || indexTemplate === void 0 ? void 0 : indexTemplate.index_template.index_patterns) !== null && _indexTemplate$index_ !== void 0 ? _indexTemplate$index_ : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: (0, _css.css)`
        min-width: 400px;
        max-height: 100px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.indexTemplate', {
    defaultMessage: 'Index template'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.indexTemplateName', {
    defaultMessage: 'Name'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      onFlyoutOpen((indexTemplate === null || indexTemplate === void 0 ? void 0 : indexTemplate.name) || '');
    }
  }, indexTemplate ? indexTemplate.name : '-', /*#__PURE__*/_react.default.createElement(_managed_badge.ManagedBadge, {
    meta: indexTemplate === null || indexTemplate === void 0 ? void 0 : indexTemplate.index_template._meta
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.indexPatterns', {
    defaultMessage: 'Patterns'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, Array.isArray(patterns) ? patterns.join(', ') : '-')))));
}