"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderIlmPhases = orderIlmPhases;
exports.parseDuration = void 0;
exports.parseDurationInSeconds = parseDurationInSeconds;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseDuration = (duration = '') => {
  const result = /^(\d+)([d|m|s|h])$/.exec(duration);
  if (!result) return undefined;
  return {
    value: Number(result[1]),
    unit: result[2]
  };
};
exports.parseDuration = parseDuration;
function parseDurationInSeconds(duration = '') {
  const parsed = parseDuration(duration);
  if (!parsed) {
    return 0;
  }
  const {
    value,
    unit
  } = parsed;
  if (unit === 's') {
    return value;
  } else if (unit === 'm') {
    return value * 60;
  } else if (unit === 'h') {
    return value * 60 * 60;
  } else if (unit === 'd') {
    return value * 24 * 60 * 60;
  }
  throw new Error(`Invalid duration unit [${unit}]`);
}
function orderIlmPhases(phases) {
  const isPhase = phase => Boolean(phase);
  return [phases.hot, phases.warm, phases.cold, phases.frozen, phases.delete].filter(isPhase);
}