"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_COLUMNS = exports.SUPPORTED_TABLE_COLUMN_NAMES = exports.FIELD_TYPE_MAP = exports.FIELD_STATUS_MAP = exports.EMPTY_CONTENT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_CONTENT = exports.EMPTY_CONTENT = '-----';
const FIELD_TYPE_MAP = exports.FIELD_TYPE_MAP = {
  boolean: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableBooleanType', {
      defaultMessage: 'Boolean'
    }),
    readonly: false
  },
  date: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableDateType', {
      defaultMessage: 'Date'
    }),
    readonly: false
  },
  keyword: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableKeywordType', {
      defaultMessage: 'Keyword'
    }),
    readonly: false
  },
  match_only_text: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableTextType', {
      defaultMessage: 'Text (match_only_text)'
    }),
    readonly: false
  },
  long: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableNumberType', {
      defaultMessage: 'Number (long)'
    }),
    readonly: false
  },
  double: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableNumberType', {
      defaultMessage: 'Number (double)'
    }),
    readonly: false
  },
  ip: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableIpType', {
      defaultMessage: 'IP'
    }),
    readonly: false
  },
  system: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableSystemType', {
      defaultMessage: 'System managed'
    }),
    readonly: true
  }
};
const FIELD_STATUS_MAP = exports.FIELD_STATUS_MAP = {
  inherited: {
    color: 'hollow',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorInheritedStatusLabel', {
      defaultMessage: 'Inherited'
    })
  },
  mapped: {
    color: 'success',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorMappedStatusLabel', {
      defaultMessage: 'Mapped'
    })
  },
  unmapped: {
    color: 'default',
    label: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorUnmappedStatusLabel', {
      defaultMessage: 'Unmapped'
    })
  }
};
const TABLE_COLUMNS = exports.TABLE_COLUMNS = {
  name: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTablenameHeader', {
      defaultMessage: 'Field'
    })
  },
  type: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTabletypeHeader', {
      defaultMessage: 'Type'
    })
  },
  format: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableformatHeader', {
      defaultMessage: 'Format'
    })
  },
  parent: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableFieldParentHeader', {
      defaultMessage: 'Field Parent (Stream)'
    })
  },
  status: {
    display: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTablestatusHeader', {
      defaultMessage: 'Status'
    })
  }
};
const SUPPORTED_TABLE_COLUMN_NAMES = exports.SUPPORTED_TABLE_COLUMN_NAMES = Object.keys(TABLE_COLUMNS);