"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _constants = require("../../../common/xsoar/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: _constants.XSOAR_CONNECTOR_ID,
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: i18n.SELECT_MESSAGE,
    actionTypeTitle: _constants.XSOAR_TITLE,
    validateParams: async actionParams => {
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        name: []
      };
      const {
        subAction,
        subActionParams
      } = actionParams;
      if (subAction === _constants.SUB_ACTION.RUN) {
        var _subActionParams$name;
        if (!(subActionParams !== null && subActionParams !== void 0 && (_subActionParams$name = subActionParams.name) !== null && _subActionParams$name !== void 0 && _subActionParams$name.length)) {
          errors.name.push(translations.NAME_REQUIRED);
        }
      }
      return {
        errors
      };
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./params'))))
  };
}