"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMappingForConnector = exports.translationMapping = exports.isValidFieldForConnector = exports.isRequiredField = void 0;
var _lodash = require("lodash");
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesRequiredFields = ['caseNameConfig', 'descriptionConfig', 'commentsConfig', 'caseIdConfig'];
const casesFields = [...casesRequiredFields];
const alertsRequiredFields = ['ruleNameConfig', 'alertIdConfig'];
const alertsFields = ['severityConfig', 'commentsConfig', ...alertsRequiredFields];
const translationMapping = exports.translationMapping = {
  caseIdConfig: i18n.SW_REQUIRED_CASE_ID,
  alertIdConfig: i18n.SW_REQUIRED_ALERT_ID,
  caseNameConfig: i18n.SW_REQUIRED_CASE_NAME,
  descriptionConfig: i18n.SW_REQUIRED_DESCRIPTION,
  commentsConfig: i18n.SW_REQUIRED_COMMENTS,
  ruleNameConfig: i18n.SW_REQUIRED_RULE_NAME,
  severityConfig: i18n.SW_REQUIRED_SEVERITY
};
const isValidFieldForConnector = (connectorType, fieldId) => {
  if (connectorType === _types.SwimlaneConnectorType.All) {
    return true;
  }
  return connectorType === _types.SwimlaneConnectorType.Alerts ? alertsFields.includes(fieldId) : casesFields.includes(fieldId);
};
exports.isValidFieldForConnector = isValidFieldForConnector;
const isRequiredField = (connectorType, fieldId) => {
  if (connectorType === _types.SwimlaneConnectorType.All) {
    return false;
  }
  if (fieldId == null || (0, _lodash.isEmpty)(fieldId)) {
    return true;
  }
  return connectorType === _types.SwimlaneConnectorType.Alerts ? alertsFields.includes(fieldId) : casesFields.includes(fieldId);
};
exports.isRequiredField = isRequiredField;
const validateMappingForConnector = (connectorType, mapping) => {
  if (connectorType === _types.SwimlaneConnectorType.All || connectorType == null) {
    return {};
  }
  const requiredFields = connectorType === _types.SwimlaneConnectorType.Alerts ? alertsRequiredFields : casesRequiredFields;
  return requiredFields.reduce((errors, field) => {
    if ((mapping === null || mapping === void 0 ? void 0 : mapping[field]) == null) {
      errors = {
        ...errors,
        [field]: translationMapping[field]
      };
    }
    return errors;
  }, {});
};
exports.validateMappingForConnector = validateMappingForConnector;