"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getConnectorType() {
  return {
    id: '.index',
    iconClass: 'indexOpen',
    selectMessage: _i18n.i18n.translate('xpack.stackConnectors.components.index.selectMessageText', {
      defaultMessage: 'Index data into Elasticsearch.'
    }),
    actionTypeTitle: _i18n.i18n.translate('xpack.stackConnectors.components.index.connectorTypeTitle', {
      defaultMessage: 'Index data'
    }),
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./es_index_connector')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./es_index_params')))),
    validateParams: async actionParams => {
      var _actionParams$documen;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        documents: new Array(),
        indexOverride: new Array()
      };
      const validationResult = {
        errors
      };
      if (!((_actionParams$documen = actionParams.documents) !== null && _actionParams$documen !== void 0 && _actionParams$documen.length) || Object.keys(actionParams.documents[0]).length === 0) {
        errors.documents.push(translations.DOCUMENT_NOT_VALID);
      }
      if (actionParams.indexOverride) {
        if (!actionParams.indexOverride.startsWith(_public.ALERT_HISTORY_PREFIX)) {
          errors.indexOverride.push(_i18n.i18n.translate('xpack.stackConnectors.components.index.error.badIndexOverrideValue', {
            defaultMessage: 'Alert history index must begin with "{alertHistoryPrefix}".',
            values: {
              alertHistoryPrefix: _public.ALERT_HISTORY_PREFIX
            }
          }));
        }
        const indexSuffix = actionParams.indexOverride.replace(_public.ALERT_HISTORY_PREFIX, '');
        if (indexSuffix.length === 0) {
          errors.indexOverride.push(translations.HISTORY_NOT_VALID);
        }
      }
      return validationResult;
    }
  };
}