"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceProviderKeys = exports.SUB_ACTION = exports.INFERENCE_CONNECTOR_TITLE = exports.INFERENCE_CONNECTOR_ID = exports.DEFAULT_TASK_TYPE = exports.DEFAULT_PROVIDER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFERENCE_CONNECTOR_TITLE = exports.INFERENCE_CONNECTOR_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.inference.connectorTypeTitle', {
  defaultMessage: 'AI Connector'
});
let ServiceProviderKeys = exports.ServiceProviderKeys = /*#__PURE__*/function (ServiceProviderKeys) {
  ServiceProviderKeys["amazonbedrock"] = "amazonbedrock";
  ServiceProviderKeys["azureopenai"] = "azureopenai";
  ServiceProviderKeys["azureaistudio"] = "azureaistudio";
  ServiceProviderKeys["cohere"] = "cohere";
  ServiceProviderKeys["elasticsearch"] = "elasticsearch";
  ServiceProviderKeys["googleaistudio"] = "googleaistudio";
  ServiceProviderKeys["googlevertexai"] = "googlevertexai";
  ServiceProviderKeys["hugging_face"] = "hugging_face";
  ServiceProviderKeys["mistral"] = "mistral";
  ServiceProviderKeys["openai"] = "openai";
  ServiceProviderKeys["anthropic"] = "anthropic";
  ServiceProviderKeys["watsonxai"] = "watsonxai";
  ServiceProviderKeys["alibabacloud-ai-search"] = "alibabacloud-ai-search";
  ServiceProviderKeys["elastic"] = "elastic";
  return ServiceProviderKeys;
}({});
const INFERENCE_CONNECTOR_ID = exports.INFERENCE_CONNECTOR_ID = '.inference';
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["UNIFIED_COMPLETION_ASYNC_ITERATOR"] = "unified_completion_async_iterator";
  SUB_ACTION["UNIFIED_COMPLETION_STREAM"] = "unified_completion_stream";
  SUB_ACTION["UNIFIED_COMPLETION"] = "unified_completion";
  SUB_ACTION["COMPLETION"] = "completion";
  SUB_ACTION["RERANK"] = "rerank";
  SUB_ACTION["TEXT_EMBEDDING"] = "text_embedding";
  SUB_ACTION["SPARSE_EMBEDDING"] = "sparse_embedding";
  SUB_ACTION["COMPLETION_STREAM"] = "completion_stream";
  return SUB_ACTION;
}({});
const DEFAULT_PROVIDER = exports.DEFAULT_PROVIDER = 'openai';
const DEFAULT_TASK_TYPE = exports.DEFAULT_TASK_TYPE = 'completion';