"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemtryMetadataSchema = exports.StreamingResponseSchema = exports.SecretsSchema = exports.RunApiLatestResponseSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConverseStreamActionParamsSchema = exports.ConverseActionParamsSchema = exports.ConfigSchema = exports.BedrockUsageSchema = exports.BedrockToolChoiceSchema = exports.BedrockMessageSchema = exports.BedrockClientSendResponseSchema = exports.BedrockClientSendParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TelemtryMetadataSchema = exports.TelemtryMetadataSchema = _configSchema.schema.object({
  pluginId: _configSchema.schema.maybe(_configSchema.schema.string()),
  aggregateBy: _configSchema.schema.maybe(_configSchema.schema.string())
});

// Connector schema
const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  apiUrl: _configSchema.schema.string(),
  defaultModel: _configSchema.schema.string({
    defaultValue: _constants.DEFAULT_BEDROCK_MODEL
  })
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  accessKey: _configSchema.schema.string(),
  secret: _configSchema.schema.string()
});
const RunActionParamsSchema = exports.RunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.string(),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  raw: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const BedrockMessageSchema = exports.BedrockMessageSchema = _configSchema.schema.object({
  role: _configSchema.schema.string(),
  content: _configSchema.schema.maybe(_configSchema.schema.string()),
  rawContent: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any()))
}, {
  validate: value => {
    if (value.content === undefined && value.rawContent === undefined) {
      return 'Must specify either content or rawContent';
    } else if (value.content !== undefined && value.rawContent !== undefined) {
      return 'content and rawContent can not be used at the same time';
    }
  }
});
const BedrockToolChoiceSchema = exports.BedrockToolChoiceSchema = _configSchema.schema.object({
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('auto'), _configSchema.schema.literal('any'), _configSchema.schema.literal('tool')]),
  name: _configSchema.schema.maybe(_configSchema.schema.string())
});
const BedrockUsageSchema = exports.BedrockUsageSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  input_tokens: _configSchema.schema.number(),
  output_tokens: _configSchema.schema.number(),
  // added with Sonnet 3.7
  cache_creation_input_tokens: _configSchema.schema.maybe(_configSchema.schema.number())
}, {
  unknowns: 'allow'
}));
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(BedrockMessageSchema),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  maxTokens: _configSchema.schema.maybe(_configSchema.schema.number()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  anthropicVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
  tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.string(),
    input_schema: _configSchema.schema.object({}, {
      unknowns: 'allow'
    })
  }))),
  toolChoice: _configSchema.schema.maybe(BedrockToolChoiceSchema),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _configSchema.schema.object({
  message: _configSchema.schema.string(),
  usage: BedrockUsageSchema
});
const InvokeAIRawActionParamsSchema = exports.InvokeAIRawActionParamsSchema = _configSchema.schema.object({
  messages: _configSchema.schema.arrayOf(_configSchema.schema.object({
    role: _configSchema.schema.string(),
    content: _configSchema.schema.any()
  })),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  system: _configSchema.schema.maybe(_configSchema.schema.string()),
  maxTokens: _configSchema.schema.maybe(_configSchema.schema.number()),
  // abort signal from client
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  anthropicVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    description: _configSchema.schema.string(),
    input_schema: _configSchema.schema.object({}, {
      unknowns: 'allow'
    })
  }))),
  toolChoice: _configSchema.schema.maybe(BedrockToolChoiceSchema),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionResponseSchema = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const RunApiLatestResponseSchema = exports.RunApiLatestResponseSchema = _configSchema.schema.object({
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: BedrockUsageSchema,
  content: _configSchema.schema.arrayOf(_configSchema.schema.object({
    type: _configSchema.schema.string(),
    text: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  }))
}, {
  unknowns: 'allow'
});
const RunActionResponseSchema = exports.RunActionResponseSchema = _configSchema.schema.object({
  completion: _configSchema.schema.string(),
  stop_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  usage: BedrockUsageSchema
}, {
  unknowns: 'ignore'
});
const StreamingResponseSchema = exports.StreamingResponseSchema = _configSchema.schema.any();

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _configSchema.schema.object({
  dashboardId: _configSchema.schema.string()
});
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _configSchema.schema.object({
  available: _configSchema.schema.boolean()
});
const BedrockClientSendParamsSchema = exports.BedrockClientSendParamsSchema = _configSchema.schema.object({
  // ConverseCommand | ConverseStreamCommand from @aws-sdk/client-bedrock-runtime
  command: _configSchema.schema.any(),
  // Kibana related properties
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema)
});
const BedrockClientSendResponseSchema = exports.BedrockClientSendResponseSchema = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
const ConverseActionParamsSchema = exports.ConverseActionParamsSchema = _configSchema.schema.object({
  // Converse API will already be validating, no need for us to strictly validate again
  messages: _configSchema.schema.arrayOf(_configSchema.schema.any()),
  model: _configSchema.schema.maybe(_configSchema.schema.string()),
  system: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  temperature: _configSchema.schema.maybe(_configSchema.schema.number()),
  maxTokens: _configSchema.schema.maybe(_configSchema.schema.number()),
  stopSequences: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  tools: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  toolChoice: _configSchema.schema.maybe(_configSchema.schema.any()),
  // Kibana related properties
  signal: _configSchema.schema.maybe(_configSchema.schema.any()),
  timeout: _configSchema.schema.maybe(_configSchema.schema.number()),
  telemetryMetadata: _configSchema.schema.maybe(TelemtryMetadataSchema),
  connectorUsageCollector: _configSchema.schema.maybe(_configSchema.schema.any())
}, {
  unknowns: 'allow'
});
const ConverseStreamActionParamsSchema = exports.ConverseStreamActionParamsSchema = ConverseActionParamsSchema;