"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableLegacyUrlConflictInternal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmbeddableLegacyUrlConflictInternal = props => {
  const {
    spacesManager,
    getStartServices,
    targetType,
    sourceId
  } = props;
  const [expandError, setExpandError] = (0, _react.useState)(false);
  const {
    value: asyncParams
  } = (0, _useAsync.default)(async () => {
    const [{
      docLinks
    }] = await getStartServices();
    const {
      id: targetSpace
    } = await spacesManager.getActiveSpace();
    const docLink = docLinks.links.spaces.kibanaDisableLegacyUrlAliasesApi;
    const aliasJsonString = JSON.stringify({
      targetSpace,
      targetType,
      sourceId
    }, null, 2);
    return {
      docLink,
      aliasJsonString
    };
  }, [getStartServices, spacesManager]);
  const {
    docLink,
    aliasJsonString
  } = asyncParams !== null && asyncParams !== void 0 ? asyncParams : {};
  if (!aliasJsonString || !docLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.embeddableLegacyUrlConflict.messageText",
    defaultMessage: "We found 2 saved objects for this panel. Disable the legacy URL alias to fix this error."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), expandError ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.embeddableLegacyUrlConflict.calloutTitle",
      defaultMessage: "Copy this JSON and use it with the {documentationLink}",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          external: true,
          href: docLink,
          target: "_blank"
        }, '_disable_legacy_url_aliases API')
      }
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "s",
    language: "json",
    isCopyable: true,
    paddingSize: "none"
  }, aliasJsonString))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setExpandError(true)
  }, _i18n.i18n.translate('xpack.spaces.embeddableLegacyUrlConflict.detailsButton', {
    defaultMessage: `View details`
  })));
};
exports.EmbeddableLegacyUrlConflictInternal = EmbeddableLegacyUrlConflictInternal;