"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RestoreSnapshotStepLogistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _lib = require("../../../../../../common/lib");
var _app_context = require("../../../../app_context");
var _lib2 = require("../../../lib");
var _data_stream_badge = require("../../../data_stream_badge");
var _data_streams_global_state_call_out = require("./data_streams_global_state_call_out");
var _data_streams_and_indices_list_help_text = require("./data_streams_and_indices_list_help_text");
var _system_indices_overwritten_callout = require("./system_indices_overwritten_callout");
var _feature_states_form_field = require("../../../feature_states_form_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RestoreSnapshotStepLogistics = ({
  snapshotDetails,
  restoreSettings,
  updateRestoreSettings,
  errors
}) => {
  var _csvToArray;
  const {
    i18n
  } = (0, _app_context.useServices)();
  const {
    docLinks
  } = (0, _app_context.useCore)();
  const {
    indices: unfilteredSnapshotIndices,
    dataStreams: snapshotDataStreams = [],
    includeGlobalState: snapshotIncludeGlobalState,
    versionId,
    featureStates: snapshotIncludeFeatureStates
  } = snapshotDetails;
  const snapshotIndices = unfilteredSnapshotIndices.filter(index => !(0, _lib.isDataStreamBackingIndex)(index));
  const snapshotIndicesAndDataStreams = snapshotIndices.concat(snapshotDataStreams);
  const comboBoxOptions = (0, _lib2.orderDataStreamsAndIndices)({
    dataStreams: snapshotDataStreams.map(dataStream => ({
      label: dataStream,
      value: {
        isDataStream: true,
        name: dataStream
      }
    })),
    indices: snapshotIndices.map(index => ({
      label: index,
      value: {
        isDataStream: false,
        name: index
      }
    }))
  });
  const {
    indices: restoreIndices,
    renamePattern,
    renameReplacement,
    partial,
    includeGlobalState,
    featureStates,
    includeAliases
  } = restoreSettings;

  // States for choosing all indices, or a subset, including caching previously chosen subset list
  const [isAllIndicesAndDataStreams, setIsAllIndicesAndDataStreams] = (0, _react.useState)(!Boolean(restoreIndices));
  const [indicesAndDataStreamsOptions, setIndicesAndDataStreamsOptions] = (0, _react.useState)(() => (0, _lib2.orderDataStreamsAndIndices)({
    dataStreams: snapshotDataStreams.map(dataStream => ({
      label: dataStream,
      append: /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, null),
      checked: isAllIndicesAndDataStreams ||
      // If indices is a string, we default to custom input mode, so we mark individual indices
      // as selected if user goes back to list mode
      typeof restoreIndices === 'string' || Array.isArray(restoreIndices) && restoreIndices.includes(dataStream) ? 'on' : undefined
    })),
    indices: snapshotIndices.map(index => ({
      label: index,
      checked: isAllIndicesAndDataStreams ||
      // If indices is a string, we default to custom input mode, so we mark individual indices
      // as selected if user goes back to list mode
      typeof restoreIndices === 'string' || Array.isArray(restoreIndices) && restoreIndices.includes(index) ? 'on' : undefined
    }))
  }));

  // State for using selectable indices list or custom patterns
  // Users with more than 100 indices will probably want to use an index pattern to select
  // them instead, so we'll default to showing them the index pattern input.
  const [selectIndicesMode, setSelectIndicesMode] = (0, _react.useState)(typeof restoreIndices === 'string' || snapshotIndicesAndDataStreams.length > 100 ? 'custom' : 'list');

  // State for custom patterns
  const [restoreIndexPatterns, setRestoreIndexPatterns] = (0, _react.useState)(typeof restoreIndices === 'string' ? restoreIndices.split(',') : []);

  // State for setting renaming indices patterns
  const [isRenamingIndices, setIsRenamingIndices] = (0, _react.useState)(Boolean(renamePattern || renameReplacement));

  // Caching state for togglable settings
  const [cachedRestoreSettings, setCachedRestoreSettings] = (0, _react.useState)({
    indices: [...snapshotIndicesAndDataStreams],
    renamePattern: '',
    renameReplacement: ''
  });
  const selectedFeatureStateOptions = (0, _react.useMemo)(() => {
    return featureStates === null || featureStates === void 0 ? void 0 : featureStates.map(feature => ({
      label: feature
    }));
  }, [featureStates]);
  const isFeatureStatesToggleEnabled = featureStates !== undefined && !(featureStates !== null && featureStates !== void 0 && featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION));
  const onFeatureStatesToggleChange = event => {
    const {
      checked
    } = event.target;
    updateRestoreSettings({
      featureStates: checked ? [] : [_constants.FEATURE_STATES_NONE_OPTION]
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "snapshotRestoreStepLogistics",
    className: "snapshotRestore__restoreForm__stepLogistics"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepLogisticsTitle",
    defaultMessage: "Restore details"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: docLinks.links.snapshotRestore.restoreSnapshot,
    target: "_blank",
    iconType: "question"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.restoreForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Snapshot and Restore docs"
  })))), snapshotDataStreams.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_data_streams_global_state_call_out.DataStreamsGlobalStateCallOut, {
    dataStreamsCount: snapshotDataStreams.length
  })) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesTitle",
      defaultMessage: "Data streams and indices"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesDescription",
      defaultMessage: "Creates new data streams and indices if they don\u2019t exist. Opens existing indices, including backing indices for a data stream, if they are closed and have the same number of shards as the snapshot index."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.allDataStreamsAndIndicesLabel",
      defaultMessage: "All data streams and indices"
    }),
    checked: isAllIndicesAndDataStreams,
    onChange: e => {
      const isChecked = e.target.checked;
      setIsAllIndicesAndDataStreams(isChecked);
      if (isChecked) {
        updateRestoreSettings({
          indices: undefined
        });
      } else {
        updateRestoreSettings({
          indices: selectIndicesMode === 'custom' ? restoreIndexPatterns.join(',') : [...(cachedRestoreSettings.indices || [])]
        });
      }
    },
    "data-test-subj": "allDsAndIndicesToggle"
  }), isAllIndicesAndDataStreams ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    className: "snapshotRestore__restoreForm__stepLogistics__indicesFieldWrapper",
    label: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.selectDataStreamsAndIndicesLabel",
      defaultMessage: "Select data streams and indices"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('custom');
        updateRestoreSettings({
          indices: restoreIndexPatterns.join(',')
        });
      },
      "data-test-subj": "restoreIndexPatternsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.indicesToggleCustomLink",
      defaultMessage: "Use index patterns"
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternLabel",
      defaultMessage: "Index patterns"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        setSelectIndicesMode('list');
        updateRestoreSettings({
          indices: cachedRestoreSettings.indices
        });
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesToggleListLink",
      defaultMessage: "Select data streams and indices"
    })))),
    helpText: selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_data_streams_and_indices_list_help_text.DataStreamsAndIndicesListHelpText, {
      onSelectionChange: selection => {
        if (selection === 'all') {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = 'on';
          });
          updateRestoreSettings({
            indices: [...snapshotIndicesAndDataStreams]
          });
          setCachedRestoreSettings({
            ...cachedRestoreSettings,
            indices: [...snapshotIndicesAndDataStreams]
          });
        } else {
          // TODO: Change this to setIndicesOptions() when https://github.com/elastic/eui/issues/2071 is fixed
          indicesAndDataStreamsOptions.forEach(option => {
            option.checked = undefined;
          });
          updateRestoreSettings({
            indices: []
          });
          setCachedRestoreSettings({
            ...cachedRestoreSettings,
            indices: []
          });
        }
      },
      selectedIndicesAndDataStreams: (_csvToArray = (0, _lib.csvToArray)(restoreIndices)) !== null && _csvToArray !== void 0 ? _csvToArray : [],
      indices: snapshotIndices,
      dataStreams: snapshotDataStreams
    }) : null,
    isInvalid: Boolean(errors.indices),
    error: errors.indices
  }, selectIndicesMode === 'list' ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: false,
    options: indicesAndDataStreamsOptions,
    onChange: options => {
      const newSelectedIndices = [];
      options.forEach(({
        label,
        checked
      }) => {
        if (checked === 'on') {
          newSelectedIndices.push(label);
        }
      });
      setIndicesAndDataStreamsOptions(options);
      updateRestoreSettings({
        indices: [...newSelectedIndices]
      });
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        indices: [...newSelectedIndices]
      });
    },
    searchable: true,
    height: 300
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false
  }, search, list)) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: comboBoxOptions,
    renderOption: ({
      value
    }) => {
      return value !== null && value !== void 0 && value.isDataStream ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        justifyContent: "spaceBetween",
        alignItems: "center",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, value.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_data_stream_badge.DataStreamBadge, null))) : value === null || value === void 0 ? void 0 : value.name;
    },
    placeholder: i18n.translate('xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternPlaceholder', {
      defaultMessage: 'Enter index patterns, i.e. logstash-*'
    }),
    selectedOptions: restoreIndexPatterns.map(pattern => ({
      label: pattern
    })),
    onCreateOption: pattern => {
      if (!pattern.trim().length) {
        return;
      }
      const newPatterns = [...restoreIndexPatterns, pattern];
      setRestoreIndexPatterns(newPatterns);
      updateRestoreSettings({
        indices: newPatterns.join(',')
      });
    },
    onChange: patterns => {
      const newPatterns = patterns.map(({
        label
      }) => label);
      setRestoreIndexPatterns(newPatterns);
      updateRestoreSettings({
        indices: newPatterns.join(',')
      });
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesTitle",
      defaultMessage: "Rename data streams and indices"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesDescription",
      defaultMessage: "Renames data streams and indices on restore. Ensure that a matching index template exists for renamed data streams."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesLabel",
      defaultMessage: "Rename data streams and indices"
    }),
    checked: isRenamingIndices,
    onChange: e => {
      const isChecked = e.target.checked;
      setIsRenamingIndices(isChecked);
      if (isChecked) {
        updateRestoreSettings({
          renamePattern: cachedRestoreSettings.renamePattern,
          renameReplacement: cachedRestoreSettings.renameReplacement
        });
      } else {
        updateRestoreSettings({
          renamePattern: undefined,
          renameReplacement: undefined
        });
      }
    },
    "data-test-subj": "restoreRenameToggle"
  }), !isRenamingIndices ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternLabel",
      defaultMessage: "Capture pattern"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternHelpText",
      defaultMessage: "Use regular expressions"
    }),
    isInvalid: Boolean(errors.renamePattern),
    error: errors.renamePattern
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: renamePattern,
    placeholder: "data_(.+)",
    onChange: e => {
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        renamePattern: e.target.value
      });
      updateRestoreSettings({
        renamePattern: e.target.value
      });
    },
    "data-test-subj": "capturePattern"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.renameReplacementLabel",
      defaultMessage: "Replacement pattern"
    }),
    isInvalid: Boolean(errors.renameReplacement),
    error: errors.renameReplacement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: renameReplacement,
    placeholder: "restored_data_$1",
    onChange: e => {
      setCachedRestoreSettings({
        ...cachedRestoreSettings,
        renameReplacement: e.target.value
      });
      updateRestoreSettings({
        renameReplacement: e.target.value
      });
    },
    "data-test-subj": "replacementPattern"
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialTitle",
      defaultMessage: "Partial restore"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialDescription",
      defaultMessage: "Allows restore of indices that don\u2019t have snapshots of all shards."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.partialLabel",
      defaultMessage: "Partial restore"
    }),
    checked: partial === undefined ? false : partial,
    onChange: e => updateRestoreSettings({
      partial: e.target.checked
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateTitle",
      defaultMessage: "Restore global state"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDescription",
      defaultMessage: "Restores the global cluster state as part of the snapshot."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: snapshotIncludeGlobalState ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDisabledDescription",
      defaultMessage: "Not available for this snapshot."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateLabel",
      defaultMessage: "Restore global state"
    }),
    checked: includeGlobalState === undefined ? false : includeGlobalState,
    onChange: e => updateRestoreSettings({
      includeGlobalState: e.target.checked
    }),
    disabled: !snapshotIncludeGlobalState,
    "data-test-subj": "includeGlobalStateSwitch"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesTitle",
      defaultMessage: "Restore feature state"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesDescription",
      defaultMessage: "Restores the configuration, history, and other data stored in Elasticsearch by a feature such as Elasticsearch security."
    }), versionId > 7120099 && isFeatureStatesToggleEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_system_indices_overwritten_callout.SystemIndicesOverwrittenCallOut, {
      featureStates: restoreSettings === null || restoreSettings === void 0 ? void 0 : restoreSettings.featureStates
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: snapshotIncludeFeatureStates ? null : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeFeatureStatesDisabledDescription",
      defaultMessage: "Not available for this snapshot."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.restoreFeatureStatesLabel",
      defaultMessage: "Restore feature state from"
    }),
    checked: isFeatureStatesToggleEnabled,
    onChange: onFeatureStatesToggleChange,
    disabled: (snapshotIncludeFeatureStates === null || snapshotIncludeFeatureStates === void 0 ? void 0 : snapshotIncludeFeatureStates.length) === 0,
    "data-test-subj": "includeFeatureStatesSwitch"
  })), isFeatureStatesToggleEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_feature_states_form_field.FeatureStatesFormField, {
    featuresOptions: snapshotIncludeFeatureStates,
    selectedOptions: selectedFeatureStateOptions,
    onUpdateFormSettings: updateRestoreSettings
  })), (snapshotIncludeFeatureStates === null || snapshotIncludeFeatureStates === void 0 ? void 0 : snapshotIncludeFeatureStates.length) === 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "question",
    color: "warning",
    "data-test-subj": "noFeatureStatesCallout",
    title: i18n.translate('xpack.snapshotRestore.restoreForm.stepLogistics.noFeatureStates', {
      defaultMessage: 'No feature states are included in this snapshot.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesTitle",
      defaultMessage: "Restore aliases"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesDescription",
      defaultMessage: "Restores index aliases along with their associated indices."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.restoreForm.stepLogistics.includeAliasesLabel",
      defaultMessage: "Restore aliases"
    }),
    checked: includeAliases === undefined ? true : includeAliases,
    onChange: e => updateRestoreSettings({
      includeAliases: e.target.checked
    }),
    "data-test-subj": "includeAliasesSwitch"
  }))));
};
exports.RestoreSnapshotStepLogistics = RestoreSnapshotStepLogistics;