"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertExpectedIndicatorSourceIndexPrivileges = assertExpectedIndicatorSourceIndexPrivileges;
var _errors = require("../../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function assertExpectedIndicatorSourceIndexPrivileges(slo, esClient) {
  const privileges = await esClient.security.hasPrivileges({
    index: [{
      names: slo.indicator.params.index,
      privileges: ['read', 'view_index_metadata']
    }]
  });
  if (!privileges.has_all_requested) {
    throw new _errors.SecurityException(`Missing ['read', 'view_index_metadata'] privileges on the source index [${slo.indicator.params.index}]`);
  }
}