"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOTAL_INDEX_PRIVILEGE_SET_VIEWER = exports.TOTAL_INDEX_PRIVILEGE_SET_EDITOR = exports.MINIMUM_INDEX_PRIVILEGE_SET_VIEWER = exports.MINIMUM_INDEX_PRIVILEGE_SET_EDITOR = void 0;
exports.getGlobalDiagnosis = getGlobalDiagnosis;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_INDEX_PRIVILEGE_SET_EDITOR = exports.MINIMUM_INDEX_PRIVILEGE_SET_EDITOR = ['write', 'read', 'view_index_metadata', 'manage'];
const TOTAL_INDEX_PRIVILEGE_SET_EDITOR = exports.TOTAL_INDEX_PRIVILEGE_SET_EDITOR = ['write', 'read', 'read_cross_cluster', 'view_index_metadata', 'manage'];
const MINIMUM_INDEX_PRIVILEGE_SET_VIEWER = exports.MINIMUM_INDEX_PRIVILEGE_SET_VIEWER = ['read'];
const TOTAL_INDEX_PRIVILEGE_SET_VIEWER = exports.TOTAL_INDEX_PRIVILEGE_SET_VIEWER = ['read', 'read_cross_cluster'];
async function getGlobalDiagnosis(esClient, licensing) {
  const licenseInfo = (await licensing.getLicense()).toJSON();
  const userWritePrivileges = await esClient.security.hasPrivileges({
    index: [{
      names: '.slo-observability.*',
      privileges: MINIMUM_INDEX_PRIVILEGE_SET_EDITOR
    }]
  });
  const userReadPrivileges = await esClient.security.hasPrivileges({
    index: [{
      names: '.slo-observability.*',
      privileges: MINIMUM_INDEX_PRIVILEGE_SET_VIEWER
    }]
  });
  return {
    licenseAndFeatures: licenseInfo,
    userPrivileges: {
      write: userWritePrivileges,
      read: userReadPrivileges
    }
  };
}