"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sliValueActionVariableDescription = exports.reasonActionVariableDescription = exports.groupingObjectActionVariableDescription = exports.alertDetailsUrlActionVariableDescription = void 0;
exports.sloBurnRateRuleType = sloBurnRateRuleType;
exports.viewInAppUrlActionVariableDescription = exports.timestampActionVariableDescription = exports.suppressedActionVariableDescription = exports.sloStatusActionVariableDescription = exports.sloNameActionVariableDescription = exports.sloInstanceIdActionVariableDescription = exports.sloIdActionVariableDescription = exports.sloErrorBudgetRemainingActionVariableDescription = exports.sloErrorBudgetConsumedActionVariableDescription = void 0;
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _slo_burn_rate = require("@kbn/response-ops-rule-params/slo_burn_rate");
var _constants = require("../../../common/constants");
var _constants2 = require("../../../../common/constants");
var _executor = require("./executor");
var _field_map = require("./field_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sloBurnRateRuleType(basePath, alertsLocator) {
  return {
    id: _ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID,
    name: _i18n.i18n.translate('xpack.slo.rules.burnRate.name', {
      defaultMessage: 'SLO burn rate'
    }),
    validate: {
      params: _slo_burn_rate.sloBurnRateParamsSchema
    },
    schemas: {
      params: {
        type: 'config-schema',
        schema: _slo_burn_rate.sloBurnRateParamsSchema
      }
    },
    defaultActionGroupId: _constants2.ALERT_ACTION.id,
    actionGroups: [_constants2.ALERT_ACTION, _constants2.HIGH_PRIORITY_ACTION, _constants2.MEDIUM_PRIORITY_ACTION, _constants2.LOW_PRIORITY_ACTION, _constants2.SUPPRESSED_PRIORITY_ACTION],
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _common.sloFeatureId,
    solution: 'observability',
    minimumLicenseRequired: 'platinum',
    isExportable: true,
    executor: (0, _executor.getRuleExecutor)(basePath),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'reason',
        description: reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: timestampActionVariableDescription
      }, {
        name: 'burnRateThreshold',
        description: thresholdActionVariableDescription
      }, {
        name: 'longWindow',
        description: windowActionVariableDescription
      }, {
        name: 'shortWindow',
        description: windowActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: viewInAppUrlActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: alertDetailsUrlActionVariableDescription
      }, {
        name: 'sloId',
        description: sloIdActionVariableDescription
      }, {
        name: 'sloName',
        description: sloNameActionVariableDescription
      }, {
        name: 'sloInstanceId',
        description: sloInstanceIdActionVariableDescription
      }, {
        name: 'suppressedAction',
        description: suppressedActionVariableDescription
      }, {
        name: 'sliValue',
        description: sliValueActionVariableDescription
      }, {
        name: 'sloStatus',
        description: sloStatusActionVariableDescription
      }, {
        name: 'sloErrorBudgetRemaining',
        description: sloErrorBudgetRemainingActionVariableDescription
      }, {
        name: 'sloErrorBudgetConsumed',
        description: sloErrorBudgetConsumedActionVariableDescription
      }, {
        name: 'grouping',
        description: groupingObjectActionVariableDescription
      }]
    },
    alerts: {
      context: _constants.SLO_RULE_REGISTRATION_CONTEXT,
      mappings: {
        fieldMap: {
          ..._alertsAsDataUtils.legacyExperimentalFieldMap,
          ..._field_map.sloRuleFieldMap
        }
      },
      useEcs: true,
      useLegacyAlerts: true,
      shouldWrite: true
    },
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  };
}
const thresholdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.thresholdDescription', {
  defaultMessage: 'The burn rate threshold value.'
});
const windowActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.windowDescription', {
  defaultMessage: 'The window duration with the associated burn rate value.'
});
const reasonActionVariableDescription = exports.reasonActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.reasonDescription', {
  defaultMessage: 'A concise description of the reason for the alert'
});
const timestampActionVariableDescription = exports.timestampActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.timestampDescription', {
  defaultMessage: 'A timestamp of when the alert was detected.'
});
const viewInAppUrlActionVariableDescription = exports.viewInAppUrlActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.viewInAppUrlDescription', {
  defaultMessage: 'The url to the SLO details page to help with further investigation.'
});
const alertDetailsUrlActionVariableDescription = exports.alertDetailsUrlActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.alertDetailsUrlDescription', {
  defaultMessage: 'Link to the alert troubleshooting view for further context and details. This will be an empty string if the server.publicBaseUrl is not configured.'
});
const sloIdActionVariableDescription = exports.sloIdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloIdDescription', {
  defaultMessage: 'The SLO unique identifier.'
});
const sloNameActionVariableDescription = exports.sloNameActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloNameDescription', {
  defaultMessage: 'The SLO name.'
});
const sloInstanceIdActionVariableDescription = exports.sloInstanceIdActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloInstanceIdDescription', {
  defaultMessage: 'The SLO instance id.'
});
const suppressedActionVariableDescription = exports.suppressedActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.suppressedActionDescription', {
  defaultMessage: 'The suppressed action group.'
});
const sliValueActionVariableDescription = exports.sliValueActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sliValueDescription', {
  defaultMessage: 'The SLI value at the time of firing the alert.'
});
const sloStatusActionVariableDescription = exports.sloStatusActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloStatusDescription', {
  defaultMessage: 'The SLO status at the time of firing the alert.'
});
const sloErrorBudgetRemainingActionVariableDescription = exports.sloErrorBudgetRemainingActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloErrorBudgetRemainingDescription', {
  defaultMessage: 'The remaining error budget at the time of firing the alert.'
});
const sloErrorBudgetConsumedActionVariableDescription = exports.sloErrorBudgetConsumedActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.sloErrorBudgetConsumedDescription', {
  defaultMessage: 'The consumed error budget at the time of firing the alert.'
});
const groupingObjectActionVariableDescription = exports.groupingObjectActionVariableDescription = _i18n.i18n.translate('xpack.slo.alerting.groupingObjectActionVariableDescription', {
  defaultMessage: 'The object containing groups that are reporting data'
});