"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityException = exports.SLONotFound = exports.SLOIdConflict = exports.SLOError = exports.InvalidTransformError = exports.InternalQueryError = exports.IllegalArgumentError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class SLOError extends Error {
  constructor(message) {
    super(message);
    this.name = this.constructor.name;
  }
}
exports.SLOError = SLOError;
class SLONotFound extends SLOError {}
exports.SLONotFound = SLONotFound;
class SLOIdConflict extends SLOError {}
exports.SLOIdConflict = SLOIdConflict;
class InternalQueryError extends SLOError {}
exports.InternalQueryError = InternalQueryError;
class IllegalArgumentError extends SLOError {}
exports.IllegalArgumentError = IllegalArgumentError;
class InvalidTransformError extends SLOError {}
exports.InvalidTransformError = InvalidTransformError;
class SecurityException extends SLOError {}
exports.SecurityException = SecurityException;