"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmIndicatorOverview = ApmIndicatorOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _convert_sli_apm_params_to_apm_app_deeplink_url = require("../../../../utils/slo/convert_sli_apm_params_to_apm_app_deeplink_url");
var _definition_item = require("../definition/definition_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ApmIndicatorOverview({
  slo
}) {
  const {
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const indicator = slo.indicator;
  if (!_sloSchema.apmTransactionDurationIndicatorSchema.is(indicator) || !_sloSchema.apmTransactionErrorRateIndicatorSchema.is(indicator)) {
    return null;
  }
  const url = (0, _convert_sli_apm_params_to_apm_app_deeplink_url.convertSliApmParamsToApmAppDeeplinkUrl)(slo);
  if (!url) {
    return null;
  }
  const link = basePath.prepend(url);
  const {
    params: {
      environment,
      service,
      transactionName,
      transactionType
    }
  } = indicator;
  return /*#__PURE__*/_react.default.createElement(_definition_item.DefinitionItem, {
    title: _i18n.i18n.translate('xpack.slo.sloDetails.overview.apmSource', {
      defaultMessage: 'APM source'
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "flexStart",
      gutterSize: "s",
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      href: link
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.apmSource.serviceLabel', {
      defaultMessage: 'service: {value}',
      values: {
        value: service
      }
    }))), environment !== _sloSchema.ALL_VALUE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      href: link
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.apmSource.environmentLabel', {
      defaultMessage: 'environment: {value}',
      values: {
        value: environment
      }
    }))), transactionType !== _sloSchema.ALL_VALUE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      href: link
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.apmSource.transactionTypeLabel', {
      defaultMessage: 'transactionType: {value}',
      values: {
        value: transactionType
      }
    }))), transactionName !== _sloSchema.ALL_VALUE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      href: link
    }, _i18n.i18n.translate('xpack.slo.sloDetails.overview.apmSource.transactionNameLabel', {
      defaultMessage: 'transactionName: {value}',
      values: {
        value: transactionName
      }
    }))))
  });
}