"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarPeriodPicker = CalendarPeriodPicker;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _duration = require("../../../../utils/slo/duration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CalendarPeriodPicker({
  slo,
  onChange
}) {
  const [periodOffset, setPeriodOffset] = (0, _react.useState)(0);
  function handleChangePeriod(offset) {
    const now = (0, _moment.default)();
    const duration = (0, _duration.toDuration)(slo.timeWindow.duration);
    const unit = duration.unit === 'w' ? 'isoWeek' : 'month';
    const durationUnit = duration.unit === 'w' ? 'week' : 'month';
    setPeriodOffset(curr => {
      const newOffset = curr + offset;
      onChange({
        from: _moment.default.utc(now).subtract(newOffset, durationUnit).startOf(unit).toDate(),
        to: _moment.default.utc(now).subtract(newOffset, durationUnit).endOf(unit).toDate()
      });
      return newOffset;
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceEvenly",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "sloSloDetailsHistoryPreviousButton",
    onClick: () => {
      handleChangePeriod(+1);
    },
    iconType: "arrowLeft"
  }, _i18n.i18n.translate('xpack.slo.sloDetailsHistory.previousPeriodButtonLabel', {
    defaultMessage: 'Previous'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, getCalendarPeriodLabel(slo, periodOffset))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "sloSloDetailsHistoryNextButton",
    disabled: periodOffset <= 0,
    onClick: () => {
      handleChangePeriod(-1);
    },
    iconType: "arrowRight",
    iconSide: "right"
  }, _i18n.i18n.translate('xpack.slo.sloDetailsHistory.nextPeriodButtonLabel', {
    defaultMessage: 'Next'
  })));
}
function getCalendarPeriodLabel(slo, calendarPeriod) {
  const duration = (0, _duration.toDuration)(slo.timeWindow.duration);
  const isWeeklyCalendarAligned = duration.unit === 'w';
  const now = (0, _moment.default)().utc();
  const start = now.clone().subtract(calendarPeriod, isWeeklyCalendarAligned ? 'week' : 'month').startOf(isWeeklyCalendarAligned ? 'isoWeek' : 'month');
  const end = now.clone().subtract(calendarPeriod, isWeeklyCalendarAligned ? 'week' : 'month').endOf(isWeeklyCalendarAligned ? 'isoWeek' : 'month');
  return `${start.format('ll')} - ${end.format('ll')}`;
}