"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sloKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sloKeys = exports.sloKeys = {
  all: ['slo'],
  lists: () => [...sloKeys.all, 'list'],
  list: filters => [...sloKeys.lists(), filters],
  group: filters => [...sloKeys.groups(), filters],
  groups: () => [...sloKeys.all, 'group'],
  overview: filters => ['overview', filters],
  details: () => [...sloKeys.all, 'details'],
  detail: (sloId, instanceId, remoteName) => [...sloKeys.details(), {
    sloId,
    instanceId,
    remoteName
  }],
  rules: () => [...sloKeys.all, 'rules'],
  rule: sloIds => [...sloKeys.rules(), sloIds],
  activeAlerts: () => [...sloKeys.all, 'activeAlerts'],
  activeAlert: sloIdsAndInstanceIds => [...sloKeys.activeAlerts(), ...sloIdsAndInstanceIds.flat()],
  historicalSummaries: () => [...sloKeys.all, 'historicalSummary'],
  historicalSummary: list => [...sloKeys.historicalSummaries(), list],
  allDefinitions: () => [...sloKeys.all, 'definitions'],
  definitions: params => [...sloKeys.allDefinitions(), params],
  globalDiagnosis: () => [...sloKeys.all, 'globalDiagnosis'],
  health: list => [...sloKeys.all, 'health', list],
  burnRates: (sloId, instanceId, windows) => [...sloKeys.all, 'burnRates', sloId, instanceId, windows],
  preview: params => [...sloKeys.all, 'preview', params],
  burnRateRules: search => [...sloKeys.all, 'burnRateRules', search],
  groupings: params => [...sloKeys.all, 'fetch_slo_groupings', params],
  bulkDeleteStatus: taskId => [...sloKeys.all, 'bulkDeleteStatus', taskId]
};