"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRate = BurnRate;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _burn_rate = require("../../../components/slo/simple_burn_rate/burn_rate");
var _use_fetch_slo_details = require("../../../hooks/use_fetch_slo_details");
var _slo_overview_details = require("../common/slo_overview_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BurnRate({
  sloId,
  sloInstanceId,
  duration,
  reloadSubject
}) {
  const containerRef = (0, _react2.useRef)(null);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react2.useState)(undefined);
  const [selectedSlo, setSelectedSlo] = (0, _react2.useState)(null);
  const [showAllGroups, setShowAllGroups] = (0, _react2.useState)(false);
  const {
    isLoading,
    data: slo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId,
    instanceId: sloInstanceId
  });
  (0, _react2.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  const isSloNotFound = !isLoading && slo === undefined;
  if (isLoading || !slo) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      justifyContent: "center",
      css: container
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingChart, null)));
  }
  if (isSloNotFound) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      justifyContent: "center",
      css: container
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.slo.sloEmbeddable.overview.sloNotFoundText', {
      defaultMessage: 'The SLO has been deleted. You can safely delete the widget from the dashboard.'
    })));
  }
  const hasGroupings = Object.keys(slo.groupings).length > 0;
  const firstGrouping = hasGroupings ? Object.entries(slo.groupings)[0] : undefined;
  const firstGroupLabel = firstGrouping ? `${firstGrouping[0]}: ${firstGrouping[1]}` : null;
  const hasMoreThanOneGrouping = Object.keys(slo.groupings).length > 1;
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-shared-item": "",
    ref: containerRef,
    style: {
      width: '100%',
      padding: 10
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    "data-test-subj": "sloBurnRateLink",
    css: link,
    color: "text",
    onClick: () => {
      setSelectedSlo(slo);
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", null, slo.name))), hasGroupings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, null, firstGroupLabel)), hasMoreThanOneGrouping && !showAllGroups ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    onClick: () => setShowAllGroups(true),
    onClickAriaLabel: _i18n.i18n.translate('xpack.slo.burnRateEmbeddable.moreInstanceAriaLabel', {
      defaultMessage: 'Show more'
    })
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateEmbeddable.moreInstanceLabel",
    defaultMessage: "+{groupingsMore} more instance",
    values: {
      groupingsMore: Object.keys(slo.groupings).length - 1
    }
  }))) : null, hasMoreThanOneGrouping && showAllGroups ? Object.entries(slo.groupings).splice(1).map(([key, value]) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, null, key, ": ", value))) : null)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react2.default.createElement(_burn_rate.SimpleBurnRate, {
    slo: slo,
    duration: duration,
    lastRefreshTime: lastRefreshTime
  }))), /*#__PURE__*/_react2.default.createElement(_slo_overview_details.SloOverviewDetails, {
    slo: selectedSlo,
    setSelectedSlo: setSelectedSlo
  }));
}
const container = (0, _react.css)`
  height: 100%;
`;
const link = ({
  euiTheme
}) => (0, _react.css)`
  font-size: ${euiTheme.size.base};
  font-weight: ${euiTheme.font.weight.bold};
`;