"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSloConfiguration = openSloConfiguration;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _reactQuery = require("@kbn/react-query");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _plugin_context = require("../../../context/plugin_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
async function openSloConfiguration(coreStart, pluginsStart, sloClient, initialState) {
  const {
    overlays
  } = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  return new Promise(async (resolve, reject) => {
    try {
      const LazySloConfiguration = /*#__PURE__*/(0, _react.lazy)(async () => {
        const {
          SloConfiguration
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./slo_configuration')));
        return {
          default: SloConfiguration
        };
      });
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
        services: {
          ...coreStart,
          ...pluginsStart
        }
      }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
        value: {
          observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
          ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
          sloClient
        }
      }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
        client: queryClient
      }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
        fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)
      }, /*#__PURE__*/_react.default.createElement(LazySloConfiguration, {
        initialInput: initialState,
        onCreate: update => {
          flyoutSession.close();
          resolve(update);
        },
        onCancel: () => {
          flyoutSession.close();
          reject();
        }
      }))))), coreStart));
    } catch (error) {
      reject(error);
    }
  });
}