"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessTreeAlert = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _data_or_dash = require("../../utils/data_or_dash");
var _helpers = require("./helpers");
var _styles = require("./styles");
var _alert_category_display_text = require("../../utils/alert_category_display_text");
var _alert_icon_tooltip_content = require("../../../common/utils/alert_icon_tooltip_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessTreeAlert = ({
  alert,
  isInvestigated,
  isSelected,
  onClick,
  selectAlert,
  onShowAlertDetails
}) => {
  var _alert$kibana, _event$category, _alert$kibana3, _event$type;
  const styles = (0, _styles.useStyles)({
    isInvestigated,
    isSelected
  });
  const {
    event
  } = alert;
  const {
    uuid,
    rule,
    workflow_status: status
  } = ((_alert$kibana = alert.kibana) === null || _alert$kibana === void 0 ? void 0 : _alert$kibana.alert) || {};
  const category = event === null || event === void 0 ? void 0 : (_event$category = event.category) === null || _event$category === void 0 ? void 0 : _event$category[0];
  const alertIconType = (0, _react.useMemo)(() => {
    if (category && category in _constants.ALERT_ICONS) return _constants.ALERT_ICONS[category];
    return _constants.ALERT_ICONS.process;
  }, [category]);
  (0, _react.useEffect)(() => {
    if (isInvestigated && uuid) {
      selectAlert(uuid);
    }
  }, [isInvestigated, uuid, selectAlert]);
  const handleExpandClick = (0, _react.useCallback)(() => {
    if (uuid) {
      onShowAlertDetails(uuid);
    }
  }, [onShowAlertDetails, uuid]);
  const handleClick = (0, _react.useCallback)(() => {
    var _alert$kibana2;
    if ((_alert$kibana2 = alert.kibana) !== null && _alert$kibana2 !== void 0 && _alert$kibana2.alert) {
      onClick(alert.kibana.alert);
    }
  }, [(_alert$kibana3 = alert.kibana) === null || _alert$kibana3 === void 0 ? void 0 : _alert$kibana3.alert, onClick]);
  if (!(alert.kibana && rule)) {
    return null;
  }
  const {
    name
  } = rule;
  const processEventAlertCategory = category !== null && category !== void 0 ? category : 'process';
  const alertCategoryDetailDisplayText = (0, _alert_category_display_text.getAlertCategoryDisplayText)(alert, category);
  const alertIconTooltipContent = (0, _alert_icon_tooltip_content.getAlertIconTooltipContent)(processEventAlertCategory);
  const eventType = Array.isArray(event === null || event === void 0 ? void 0 : event.type) ? event === null || event === void 0 ? void 0 : (_event$type = event.type) === null || _event$type === void 0 ? void 0 : _event$type[0] : event === null || event === void 0 ? void 0 : event.type;
  return /*#__PURE__*/_react.default.createElement("div", {
    key: uuid,
    css: styles.alert,
    "data-id": uuid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    wrap: true,
    onClick: handleClick,
    "data-test-subj": `sessionView:sessionViewAlertDetail-${uuid}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "expand",
    "aria-label": "expand",
    "data-test-subj": `sessionView:sessionViewAlertDetailExpand-${uuid}`,
    onClick: handleExpandClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: alertIconTooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: alertIconType,
    color: "danger"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.processAlertDisplayContainer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `sessionView:sessionViewAlertDetailRuleName-${uuid}-text`,
    css: styles.alertName,
    size: "s"
  }, (0, _data_or_dash.dataOrDash)(name)), alertCategoryDetailDisplayText && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.processPanel,
    color: "subdued",
    hasBorder: true,
    hasShadow: false,
    borderRadius: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `sessionView:sessionViewAlertDetail-${uuid}-text`,
    css: styles.alertName,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "alertCategoryDetailText"
  }, alertCategoryDetailDisplayText))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _helpers.getBadgeColorFromAlertStatus)(status),
    css: styles.alertStatus
  }, (0, _data_or_dash.dataOrDash)(status))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.actionBadge
  }, event === null || event === void 0 ? void 0 : event.action)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, eventType === 'denied' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.actionBadge,
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.blockedBadge",
    defaultMessage: "Blocked"
  })))));
};
exports.ProcessTreeAlert = ProcessTreeAlert;