"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateApiKeyFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _securityApiKeyManagement = require("@kbn/security-api-key-management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ROLE_DESCRIPTORS = `{
  "serverless_search": {
    "indices": [{
      "names": ["*"],
      "privileges": [
        "all"
      ]
    }]
  }
}`;
const DEFAULT_METADATA = `{
  "application": "myapp"
}`;
const CreateApiKeyFlyout = ({
  onClose,
  setApiKey,
  user
}) => {
  return /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyFlyout, {
    onCancel: onClose,
    onSuccess: setApiKey,
    apiKey: undefined,
    currentUser: user,
    defaultRoleDescriptors: DEFAULT_ROLE_DESCRIPTORS,
    defaultMetadata: DEFAULT_METADATA,
    defaultExpiration: "60"
  });
};
exports.CreateApiKeyFlyout = CreateApiKeyFlyout;