"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _securityApiKeyManagement = require("@kbn/security-api-key-management");
var _use_kibana = require("../../hooks/use_kibana");
var _routes = require("../../../../common/routes");
var _create_api_key_flyout = require("./create_api_key_flyout");
require("./api_key.scss");
var _use_api_key = require("../../hooks/api/use_api_key");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isCreatedResponse(value) {
  if (value.id) {
    return true;
  }
  return false;
}
const ApiKeyPanel = ({
  setClientApiKey
}) => {
  const {
    http,
    user
  } = (0, _use_kibana.useKibanaServices)();
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react2.useState)(false);
  const {
    data
  } = (0, _use_api_key.useGetApiKeys)();
  const [apiKey, setApiKey] = (0, _react2.useState)(undefined);
  const saveApiKey = value => {
    setApiKey(value);
  };

  // Prevent flickering in the most common case of having access to manage api keys
  const canManageOwnApiKey = !data || data.canManageOwnApiKey;
  (0, _react2.useEffect)(() => {
    if (apiKey) {
      setClientApiKey(apiKey.encoded);
      setIsFlyoutOpen(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [apiKey]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, isFlyoutOpen && /*#__PURE__*/_react2.default.createElement(_create_api_key_flyout.CreateApiKeyFlyout, {
    onClose: () => setIsFlyoutOpen(false),
    setApiKey: value => {
      if (isCreatedResponse(value)) {
        saveApiKey(value);
      }
    },
    user: user
  }), apiKey ? /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    className: "apiKeySuccessPanel",
    "data-test-subj": "api-key-create-success-panel"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiStep, {
    css: (0, _react.css)`
              .euiStep__content {
                padding-bottom: 0;
              }
            `,
    status: "complete",
    headingElement: "h3",
    title: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.apiKeyStepTitle', {
      defaultMessage: 'Store this API key'
    }),
    titleSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.apiKeyStepDescription', {
    defaultMessage: "You'll only see this key once, so save it somewhere safe. We don't store your API keys, so if you lose a key you'll need to generate a replacement."
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_securityApiKeyManagement.ApiKeySelectableTokenField, {
    createdApiKey: apiKey
  }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: 'plain'
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement("h3", null, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.panel.title', {
    defaultMessage: 'Add an API Key'
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.panel.description', {
    defaultMessage: 'Use an existing key, or create a new one and copy it somewhere safe.'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), !canManageOwnApiKey && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    iconType: "warningFilled"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.panel.noUserPrivileges', {
    defaultMessage: "You don't have access to manage API keys"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircleFilled",
    size: "s",
    fill: true,
    onClick: () => setIsFlyoutOpen(true),
    disabled: !canManageOwnApiKey,
    "data-test-subj": "new-api-key-button",
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.apiKey.newButton.ariaLabel', {
      defaultMessage: 'Add new API key'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.newButtonLabel', {
    defaultMessage: 'New'
  }))))), canManageOwnApiKey && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("span", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    size: "s",
    href: http.basePath.prepend(_routes.MANAGEMENT_API_KEYS),
    target: "_blank",
    "data-test-subj": "manage-api-keys-button",
    "aria-label": _i18n.i18n.translate('xpack.serverlessSearch.apiKey.manage.ariaLabel', {
      defaultMessage: 'Manage API keys'
    })
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.manageLabel', {
    defaultMessage: 'Manage'
  })))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, !!(data !== null && data !== void 0 && data.apiKeys) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "info",
    color: "subdued"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.apiKey.activeKeys",
    defaultMessage: "You have {number} active keys.",
    values: {
      number: /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
        color: data.apiKeys.length > 0 ? 'success' : 'warning',
        "data-test-subj": "api-keys-count-badge"
      }, data.apiKeys.length)
    }
  }))))))));
};
exports.ApiKeyPanel = ApiKeyPanel;