"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteListItemResponse = exports.DeleteListItemRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _list_common = require("../model/list_common.gen");
var _list_schemas = require("../model/list_schemas.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Delete list item API endpoint
 *   version: 2023-10-31
 */

const DeleteListItemRequestQuery = exports.DeleteListItemRequestQuery = _zod.z.object({
  /**
   * Required if `list_id` and `value` are not specified
   */
  id: _list_common.ListId.optional(),
  /**
   * Required if `id` is not specified
   */
  list_id: _list_common.ListId.optional(),
  /**
   * Required if `id` is not specified
   */
  value: _zod.z.string().optional(),
  /**
   * Determines when changes made by the request are made visible to search
   */
  refresh: _zod.z.enum(['true', 'false', 'wait_for']).optional().default('false')
});
const DeleteListItemResponse = exports.DeleteListItemResponse = _zod.z.union([_list_schemas.ListItem, _zod.z.array(_list_schemas.ListItem)]);