"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertSuppressionUsage = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertSuppressionUsage = ruleAttributes => {
  var _ruleAttributes$param, _ruleAttributes$param2, _ruleAttributes$param3, _ruleAttributes$param4;
  if (ruleAttributes.params.alertSuppression == null) {
    return {
      hasAlertSuppressionPerRuleExecution: false,
      hasAlertSuppressionPerTimePeriod: false,
      hasAlertSuppressionMissingFieldsStrategyDoNotSuppress: false,
      alertSuppressionFieldsCount: 0
    };
  }
  switch (ruleAttributes.params.type) {
    case 'threshold':
      return {
        hasAlertSuppressionPerRuleExecution: false,
        hasAlertSuppressionPerTimePeriod: true,
        hasAlertSuppressionMissingFieldsStrategyDoNotSuppress: false,
        alertSuppressionFieldsCount: ((_ruleAttributes$param = ruleAttributes.params) === null || _ruleAttributes$param === void 0 ? void 0 : (_ruleAttributes$param2 = _ruleAttributes$param.threshold) === null || _ruleAttributes$param2 === void 0 ? void 0 : (_ruleAttributes$param3 = _ruleAttributes$param2.field) === null || _ruleAttributes$param3 === void 0 ? void 0 : _ruleAttributes$param3.length) || 0
      };
    case 'query':
    case 'saved_query':
    case 'new_terms':
    case 'threat_match':
    case 'machine_learning':
    case 'esql':
    case 'eql':
      return {
        hasAlertSuppressionPerRuleExecution: ruleAttributes.params.alertSuppression.duration == null,
        hasAlertSuppressionPerTimePeriod: ruleAttributes.params.alertSuppression.duration != null,
        hasAlertSuppressionMissingFieldsStrategyDoNotSuppress: ruleAttributes.params.alertSuppression.missingFieldsStrategy === 'doNotSuppress',
        alertSuppressionFieldsCount: ((_ruleAttributes$param4 = ruleAttributes.params.alertSuppression.groupBy) === null || _ruleAttributes$param4 === void 0 ? void 0 : _ruleAttributes$param4.length) || 0
      };
    default:
      return {
        hasAlertSuppressionPerRuleExecution: false,
        hasAlertSuppressionPerTimePeriod: false,
        hasAlertSuppressionMissingFieldsStrategyDoNotSuppress: false,
        alertSuppressionFieldsCount: 0
      };
  }
};
exports.getAlertSuppressionUsage = getAlertSuppressionUsage;