"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlKnowledgeBase = void 0;
var _server = require("@kbn/inference-plugin/server");
var _rxjs = require("rxjs");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EsqlKnowledgeBase {
  constructor(connectorId, migrationId, client, logger) {
    this.connectorId = connectorId;
    this.migrationId = migrationId;
    this.client = client;
    this.logger = logger;
  }
  async translate(input) {
    const {
      content
    } = await (0, _rxjs.lastValueFrom)((0, _server.naturalLanguageToEsql)({
      client: this.client,
      connectorId: this.connectorId,
      input,
      logger: this.logger,
      metadata: {
        connectorTelemetry: {
          pluginId: _constants.TELEMETRY_SIEM_MIGRATION_ID,
          aggregateBy: this.migrationId
        }
      }
    }));
    return content;
  }
}
exports.EsqlKnowledgeBase = EsqlKnowledgeBase;