"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rule_migrations_data_integrations_client = require("./rule_migrations_data_integrations_client");
var _rule_migrations_data_prebuilt_rules_client = require("./rule_migrations_data_prebuilt_rules_client");
var _rule_migrations_data_resources_client = require("./rule_migrations_data_resources_client");
var _rule_migrations_data_rules_client = require("./rule_migrations_data_rules_client");
var _rule_migrations_data_lookups_client = require("./rule_migrations_data_lookups_client");
var _rule_migrations_data_migration_client = require("./rule_migrations_data_migration_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationsDataClient {
  constructor(indexNameProviders, currentUser, esScopedClient, logger, spaceId, dependencies) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    (0, _defineProperty2.default)(this, "migrations", void 0);
    (0, _defineProperty2.default)(this, "rules", void 0);
    (0, _defineProperty2.default)(this, "resources", void 0);
    (0, _defineProperty2.default)(this, "integrations", void 0);
    (0, _defineProperty2.default)(this, "prebuiltRules", void 0);
    (0, _defineProperty2.default)(this, "lookups", void 0);
    this.migrations = new _rule_migrations_data_migration_client.RuleMigrationsDataMigrationClient(indexNameProviders.migrations, currentUser, esScopedClient, logger, dependencies);
    this.rules = new _rule_migrations_data_rules_client.RuleMigrationsDataRulesClient(indexNameProviders.rules, currentUser, esScopedClient, logger, dependencies);
    this.resources = new _rule_migrations_data_resources_client.RuleMigrationsDataResourcesClient(indexNameProviders.resources, currentUser, esScopedClient, logger, dependencies);
    this.integrations = new _rule_migrations_data_integrations_client.RuleMigrationsDataIntegrationsClient(indexNameProviders.integrations, currentUser, esScopedClient, logger, dependencies);
    this.prebuiltRules = new _rule_migrations_data_prebuilt_rules_client.RuleMigrationsDataPrebuiltRulesClient(indexNameProviders.prebuiltrules, currentUser, esScopedClient, logger, dependencies);
    this.lookups = new _rule_migrations_data_lookups_client.RuleMigrationsDataLookupsClient(currentUser, esScopedClient, logger, spaceId);
    this.logger = logger;
    this.esClient = esScopedClient.asInternalUser;
  }

  /**
   *
   * Deletes a migration and all its associated rules and resources.
   *
   */
  async deleteMigration(migrationId) {
    const migrationDeleteOperations = await this.migrations.prepareDelete({
      id: migrationId
    });
    const rulesByMigrationIdDeleteOperations = await this.rules.prepareDelete(migrationId);
    const resourcesByMigrationIdDeleteOperations = await this.resources.prepareDelete(migrationId);
    return this.esClient.bulk({
      refresh: 'wait_for',
      operations: [...migrationDeleteOperations, ...rulesByMigrationIdDeleteOperations, ...resourcesByMigrationIdDeleteOperations]
    }).then(() => {
      this.logger.info(`Deleted migration ${migrationId}`);
    }).catch(error => {
      this.logger.error(`Error deleting migration ${migrationId}: ${error}`);
      throw error;
    });
  }
}
exports.RuleMigrationsDataClient = RuleMigrationsDataClient;