"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEnginePrivilegesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _audit = require("../../audit");
var _audit2 = require("../../risk_score/audit");
var _risk_engine_privileges = require("../risk_engine_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEnginePrivilegesRoute = (router, getStartServices) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.RISK_ENGINE_PRIVILEGES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (context, request, response) => {
    var _securitySolution$get;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const [_, {
      security
    }] = await getStartServices();
    const securitySolution = await context.securitySolution;
    const body = await (0, _risk_engine_privileges.getUserRiskEnginePrivileges)(request, security);
    (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
      message: 'User checked if they have the required privileges to configure the risk engine',
      event: {
        action: _audit2.RiskScoreAuditActions.RISK_ENGINE_PRIVILEGES_GET,
        category: _audit.AUDIT_CATEGORY.AUTHENTICATION,
        type: _audit.AUDIT_TYPE.ACCESS,
        outcome: _audit.AUDIT_OUTCOME.SUCCESS
      }
    });
    try {
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.riskEnginePrivilegesRoute = riskEnginePrivilegesRoute;