"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserAssetCriticalityPrivileges = void 0;
var _check_and_format_privileges = require("../utils/check_and_format_privileges");
var _asset_criticality = require("../../../../common/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserAssetCriticalityPrivileges = async (request, security) => {
  return (0, _check_and_format_privileges.checkAndFormatPrivileges)({
    request,
    security,
    privilegesToCheck: {
      elasticsearch: {
        cluster: [],
        index: _asset_criticality.ASSET_CRITICALITY_REQUIRED_ES_INDEX_PRIVILEGES
      }
    }
  });
};
exports.getUserAssetCriticalityPrivileges = getUserAssetCriticalityPrivileges;