"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initiateExcludedDocuments = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initiateExcludedDocuments = ({
  state,
  isRuleAggregating,
  tuple,
  hasMvExpand,
  query
}) => {
  var _state$excludedDocume, _state$excludedDocume2;
  // exclude ids from store if mv_expand used and query has changed. this would allow to create alerts from changed mv_expand queries
  if (isRuleAggregating || !(state !== null && state !== void 0 && state.excludedDocuments) || hasMvExpand && query !== state.lastQuery) {
    return [];
  }
  return (_state$excludedDocume = state === null || state === void 0 ? void 0 : (_state$excludedDocume2 = state.excludedDocuments) === null || _state$excludedDocume2 === void 0 ? void 0 : _state$excludedDocume2.filter(({
    timestamp
  }) => {
    return timestamp && timestamp >= tuple.from.toISOString();
  })) !== null && _state$excludedDocume !== void 0 ? _state$excludedDocume : [];
};
exports.initiateExcludedDocuments = initiateExcludedDocuments;