"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAlertId = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _robust_field_access = require("../../utils/source_fields_merging/utils/robust_field_access");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generates id for ES|QL alert.
 * Id is generated as hash of event properties and rule/space config identifiers.
 * This would allow to deduplicate alerts, generated from the same event.
 */
const generateAlertId = ({
  event,
  spaceId,
  completeRule,
  tuple,
  isRuleAggregating,
  index,
  expandedFields
}) => {
  const ruleRunId = tuple.from.toISOString() + tuple.to.toISOString();
  if (!isRuleAggregating && event._id) {
    const idFields = [event._id, event._version, event._index, `${spaceId}:${completeRule.alertId}`, ...retrieveExpandedValues({
      event,
      fields: expandedFields
    })];
    return (0, _objectHash.default)(idFields);
  } else {
    return (0, _objectHash.default)([ruleRunId, completeRule.ruleParams.query, `${spaceId}:${completeRule.alertId}`, index]);
  }
};

/**
 * returns array of values from source event for requested list of fields
 * undefined values are dropped
 */
exports.generateAlertId = generateAlertId;
const retrieveExpandedValues = ({
  event,
  fields
}) => {
  if (!fields || !event._source) {
    return [];
  }
  const values = fields.map(field => event._source ? (0, _robust_field_access.robustGet)({
    key: field,
    document: event._source
  }) : undefined);
  return fields.length === 0 ? [event] : values.filter(Boolean);
};