"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateGetRuleHealthRequest = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _health_interval = require("../health_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateGetRuleHealthRequest = body => {
  var _body$debug;
  const now = (0, _moment.default)();
  const interval = (0, _health_interval.validateHealthInterval)(body.interval, now);
  return {
    ruleId: body.rule_id,
    interval,
    debug: (_body$debug = body.debug) !== null && _body$debug !== void 0 ? _body$debug : false,
    requestReceivedAt: now.utc().toISOString()
  };
};
exports.validateGetRuleHealthRequest = validateGetRuleHealthRequest;