"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findLatestPackageVersion = findLatestPackageVersion;
exports.installEndpointPackage = installEndpointPackage;
exports.installPrebuiltRulesPackage = installPrebuiltRulesPackage;
var _constants = require("../../../../../../common/detection_engine/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Installs the prebuilt rules package of the config's specified or latest version.
 *
 * @param config Kibana config
 * @param context Request handler context
 */
async function installPrebuiltRulesPackage(config, context) {
  let pkgVersion = config.prebuiltRulesPackageVersion;
  if (!pkgVersion) {
    // Find latest package if the version isn't specified in the config
    pkgVersion = await findLatestPackageVersion(context, _constants.PREBUILT_RULES_PACKAGE_NAME);
  }
  return context.getInternalFleetServices().packages.ensureInstalledPackage({
    pkgName: _constants.PREBUILT_RULES_PACKAGE_NAME,
    pkgVersion
  });
}
async function installEndpointPackage(config, context) {
  const pkgVersion = await findLatestPackageVersion(context, _constants.ENDPOINT_PACKAGE_NAME);
  return context.getInternalFleetServices().packages.ensureInstalledPackage({
    pkgName: _constants.ENDPOINT_PACKAGE_NAME,
    pkgVersion
  });
}
async function findLatestPackageVersion(context, packageName) {
  const securityAppClient = context.getAppClient();
  const packageClient = context.getInternalFleetServices().packages;

  // Use prerelease versions in dev environment
  const isPrerelease = securityAppClient.getBuildFlavor() === 'traditional' && (securityAppClient.getKibanaVersion().includes('-SNAPSHOT') || securityAppClient.getKibanaBranch() === 'main');
  const result = await packageClient.fetchFindLatestPackage(packageName, {
    prerelease: isPrerelease
  });
  return result.version;
}