"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchActionRequestById = void 0;
var _errors = require("../../../errors");
var _constants = require("../../../../../common/endpoint/constants");
var _utils = require("../../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches a single Action request document.
 * @param esClient
 * @param actionId
 *
 * @throws
 */
const fetchActionRequestById = async (esClient, actionId) => {
  var _searchResponse$hits$, _searchResponse$hits$2;
  const searchResponse = await esClient.search({
    index: _constants.ENDPOINT_ACTIONS_INDEX,
    query: {
      bool: {
        filter: [{
          term: {
            action_id: actionId
          }
        }]
      }
    },
    size: 1
  }, {
    ignore: [404]
  }).catch(_utils.catchAndWrapError);
  const actionRequest = (_searchResponse$hits$ = searchResponse.hits.hits) === null || _searchResponse$hits$ === void 0 ? void 0 : (_searchResponse$hits$2 = _searchResponse$hits$[0]) === null || _searchResponse$hits$2 === void 0 ? void 0 : _searchResponse$hits$2._source;
  if (!actionRequest) {
    throw new _errors.NotFoundError(`Action with id '${actionId}' not found.`);
  }
  return actionRequest;
};
exports.fetchActionRequestById = fetchActionRequestById;