"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckResourcesStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_missing_resources = require("../../../../../../service/hooks/use_get_missing_resources");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckResourcesStep = ({
  status,
  migrationStats,
  onMissingResourcesFetched
}) => {
  const {
    getMissingResources,
    isLoading,
    error
  } = (0, _use_get_missing_resources.useGetMissingResources)(onMissingResourcesFetched);
  (0, _react.useEffect)(() => {
    if (status === 'current' && migrationStats !== null && migrationStats !== void 0 && migrationStats.id) {
      getMissingResources(migrationStats.id);
    }
  }, [getMissingResources, status, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id]);
  const uploadStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.RULES_DATA_INPUT_CHECK_RESOURCES_TITLE,
    status: uploadStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, i18n.RULES_DATA_INPUT_CHECK_RESOURCES_DESCRIPTION)
  };
};
exports.useCheckResourcesStep = useCheckResourcesStep;