"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationDataInputFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/siem_migrations/constants");
var _rules_data_input = require("./steps/rules/rules_data_input");
var _use_start_migration = require("../../service/hooks/use_start_migration");
var _constants2 = require("./steps/constants");
var _macros_data_input = require("./steps/macros/macros_data_input");
var _lookups_data_input = require("./steps/lookups/lookups_data_input");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MigrationDataInputFlyout = exports.MigrationDataInputFlyout = /*#__PURE__*/_react.default.memo(({
  onClose,
  migrationStats: initialMigrationSats
}) => {
  const [migrationStats, setMigrationStats] = (0, _react.useState)(initialMigrationSats);
  const [missingResourcesIndexed, setMissingResourcesIndexed] = (0, _react.useState)();
  const isRetry = (migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.status) === _constants.SiemMigrationTaskStatus.FINISHED;
  const {
    startMigration,
    isLoading: isStartLoading
  } = (0, _use_start_migration.useStartMigration)(onClose);
  const onStartMigration = (0, _react.useCallback)(() => {
    if (migrationStats !== null && migrationStats !== void 0 && migrationStats.id) {
      const retryFilter = isRetry ? _constants.SiemMigrationRetryFilter.NOT_FULLY_TRANSLATED : undefined;
      startMigration(migrationStats.id, retryFilter);
    }
  }, [startMigration, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id, isRetry]);
  const [dataInputStep, setDataInputStep] = (0, _react.useState)(_constants2.DataInputStep.Rules);
  const onMigrationCreated = (0, _react.useCallback)(createdMigrationStats => {
    setMigrationStats(createdMigrationStats);
  }, []);
  const onMissingResourcesFetched = (0, _react.useCallback)(missingResources => {
    const newMissingResourcesIndexed = missingResources.reduce((acc, {
      type,
      name
    }) => {
      if (type === 'macro') {
        acc.macros.push(name);
      } else if (type === 'lookup') {
        acc.lookups.push(name);
      }
      return acc;
    }, {
      macros: [],
      lookups: []
    });
    setMissingResourcesIndexed(newMissingResourcesIndexed);
    if (newMissingResourcesIndexed.macros.length) {
      setDataInputStep(_constants2.DataInputStep.Macros);
      return;
    }
    if (newMissingResourcesIndexed.lookups.length) {
      setDataInputStep(_constants2.DataInputStep.Lookups);
      return;
    }
    setDataInputStep(_constants2.DataInputStep.End);
  }, []);
  const onAllLookupsCreated = (0, _react.useCallback)(() => {
    setDataInputStep(_constants2.DataInputStep.End);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    onClose: onClose,
    size: 850,
    maxWidth: 1200,
    minWidth: 500,
    "data-test-subj": "uploadRulesFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.dataInputFlyout.title",
    defaultMessage: "Upload Splunk SIEM rules"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rules_data_input.RulesDataInput, {
    dataInputStep: dataInputStep,
    migrationStats: migrationStats,
    onMigrationCreated: onMigrationCreated,
    onMissingResourcesFetched: onMissingResourcesFetched
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_macros_data_input.MacrosDataInput, {
    dataInputStep: dataInputStep,
    missingMacros: missingResourcesIndexed === null || missingResourcesIndexed === void 0 ? void 0 : missingResourcesIndexed.macros,
    migrationStats: migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetched
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_lookups_data_input.LookupsDataInput, {
    dataInputStep: dataInputStep,
    missingLookups: missingResourcesIndexed === null || missingResourcesIndexed === void 0 ? void 0 : missingResourcesIndexed.lookups,
    migrationStats: migrationStats,
    onAllLookupsCreated: onAllLookupsCreated
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.dataInputFlyout.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onStartMigration,
    disabled: !(migrationStats !== null && migrationStats !== void 0 && migrationStats.id),
    isLoading: isStartLoading,
    "data-test-subj": "startMigrationButton"
  }, isRetry ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.dataInputFlyout.retryTranslateButton",
    defaultMessage: "Retry translation"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.dataInputFlyout.translateButton",
    defaultMessage: "Translate"
  }))))));
});
MigrationDataInputFlyout.displayName = 'MigrationDataInputFlyout';