"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationCardTopCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_onboarding_service = require("../../../../../hooks/use_onboarding_service");
var _agentless_available_callout = require("./agentless_available_callout");
var _active_integrations_callout = require("./active_integrations_callout");
var _endpoint_callout = require("./endpoint_callout");
var _types = require("../../../../../../../common/lib/integrations/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationCardTopCallout = exports.IntegrationCardTopCallout = /*#__PURE__*/_react.default.memo(({
  activeIntegrationsCount,
  isAgentRequired,
  selectedTabId
}) => {
  const {
    isAgentlessAvailable$
  } = (0, _use_onboarding_service.useOnboardingService)();
  const isAgentlessAvailable = (0, _useObservable.default)(isAgentlessAvailable$, undefined);
  const showActiveCallout = activeIntegrationsCount > 0 || isAgentRequired;
  const showAgentlessCallout = isAgentlessAvailable && activeIntegrationsCount === 0 && selectedTabId !== _types.IntegrationTabId.endpoint;
  const showEndpointCallout = activeIntegrationsCount === 0 && selectedTabId === _types.IntegrationTabId.endpoint;
  if (!showAgentlessCallout && !showEndpointCallout && !showActiveCallout) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showEndpointCallout && /*#__PURE__*/_react.default.createElement(_endpoint_callout.EndpointCallout, null), showAgentlessCallout && /*#__PURE__*/_react.default.createElement(_agentless_available_callout.AgentlessAvailableCallout, null), showActiveCallout && /*#__PURE__*/_react.default.createElement(_active_integrations_callout.ActiveIntegrationsCallout, {
    isAgentRequired: isAgentRequired,
    activeIntegrationsCount: activeIntegrationsCount
  }));
});
IntegrationCardTopCallout.displayName = 'IntegrationCardTopCallout';