"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactEntryCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_header = require("./components/card_header");
var _card_sub_header = require("./components/card_sub_header");
var _criteria_conditions = require("./components/criteria_conditions");
var _use_normalized_artifact = require("./hooks/use_normalized_artifact");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _card_container_panel = require("./components/card_container_panel");
var _card_section_panel = require("./components/card_section_panel");
var _card_comments = require("./components/card_comments");
var _use_policy_nav_links = require("./hooks/use_policy_nav_links");
var _description_field = require("./components/description_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display Artifact Items (ex. Trusted App, Event Filter, etc) as a card.
 * This component is a TS Generic that allows you to set what the Item type is
 */
const ArtifactEntryCard = exports.ArtifactEntryCard = /*#__PURE__*/(0, _react.memo)(({
  item,
  policies,
  loadingPoliciesList = false,
  actions,
  hideDescription = false,
  hideComments = false,
  Decorator,
  'data-test-subj': dataTestSubj,
  ...commonProps
}) => {
  const artifact = (0, _use_normalized_artifact.useNormalizedArtifact)(item);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const policyNavLinks = (0, _use_policy_nav_links.usePolicyNavLinks)(artifact, policies);
  return /*#__PURE__*/_react.default.createElement(_card_container_panel.CardContainerPanel, (0, _extends2.default)({}, commonProps, {
    "data-test-subj": dataTestSubj
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, {
    className: "top-section"
  }, /*#__PURE__*/_react.default.createElement(_card_header.CardHeader, {
    name: artifact.name,
    createdDate: artifact.created_at,
    updatedDate: artifact.updated_at,
    actions: actions,
    "data-test-subj": getTestId('header')
  }), /*#__PURE__*/_react.default.createElement(_card_sub_header.CardSubHeader, {
    createdBy: artifact.created_by,
    updatedBy: artifact.updated_by,
    policies: policyNavLinks,
    loadingPoliciesList: loadingPoliciesList,
    "data-test-subj": getTestId('subHeader')
  }), !hideDescription && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
    "data-test-subj": getTestId('description')
  }, artifact.description)), !hideComments ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hideDescription && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_card_comments.CardComments, {
    comments: artifact.comments,
    "data-test-subj": getTestId('comments')
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_card_section_panel.CardSectionPanel, {
    className: "bottom-section"
  }, Decorator && /*#__PURE__*/_react.default.createElement(Decorator, {
    item: item,
    "data-test-subj": getTestId('decorator')
  }), /*#__PURE__*/_react.default.createElement(_criteria_conditions.CriteriaConditions, {
    os: artifact.os,
    entries: artifact.entries,
    "data-test-subj": getTestId('criteriaConditions')
  })));
});
ArtifactEntryCard.displayName = 'ArtifactEntryCard';