"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MISSING_CONNECTOR_CALLOUT_TEST_ID = exports.MISSING_CONNECTOR_CALLOUT_LINK_TEST_ID = exports.ConnectorMissingCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISSING_CONNECTOR = _i18n.i18n.translate('xpack.securitySolution.alertSummary.missingConnector', {
  defaultMessage: 'Missing connector'
});
const CONNECTOR_MISSING_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.noConnectorMessage', {
  defaultMessage: 'Your default AI connector is invalid and may have been deleted.'
});
const CONNECTOR_MISSING_MESSAGE_ADMIN = _i18n.i18n.translate('xpack.securitySolution.alertSummary.noConnectorMessageForAdmin', {
  defaultMessage: 'Your default AI connector is invalid and may have been deleted. You may update the default AI connector via'
});
const ADVANCED_SETTINGS_LINK_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.advancedSettingsLinkTitle', {
  defaultMessage: 'Security Solution advanced settings'
});
const MISSING_CONNECTOR_CALLOUT_TEST_ID = exports.MISSING_CONNECTOR_CALLOUT_TEST_ID = 'ai-for-soc-alert-flyout-missing-connector-callout';
const MISSING_CONNECTOR_CALLOUT_LINK_TEST_ID = exports.MISSING_CONNECTOR_CALLOUT_LINK_TEST_ID = 'ai-for-soc-alert-flyout-missing-connector-callout-link';
/**
 * Callout displayed in the AI for SOC alert flyout.
 * It is rendered in the alert summary section, and will help users add a connector if it is missing.
 */
const ConnectorMissingCallout = exports.ConnectorMissingCallout = /*#__PURE__*/(0, _react.memo)(({
  canSeeAdvancedSettings
}) => {
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigateTo)();
  const goToKibanaSettings = (0, _react.useCallback)(() => navigateTo({
    appId: 'management',
    path: '/kibana/settings?query=defaultAIConnector'
  }), [navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": MISSING_CONNECTOR_CALLOUT_TEST_ID,
    iconType: "error",
    title: MISSING_CONNECTOR
  }, /*#__PURE__*/_react.default.createElement("p", null, canSeeAdvancedSettings ? CONNECTOR_MISSING_MESSAGE_ADMIN : CONNECTOR_MISSING_MESSAGE, canSeeAdvancedSettings && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": MISSING_CONNECTOR_CALLOUT_LINK_TEST_ID,
    onClick: goToKibanaSettings
  }, ADVANCED_SETTINGS_LINK_TITLE), '.')));
});
ConnectorMissingCallout.displayName = 'ConnectorMissingCallout';