"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDeletePrebuiltSavedObjects = exports.bulkCreatePrebuiltSavedObjects = void 0;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _constants = require("../../components/risk_score/constants");
var _constants2 = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toastLifeTimeMs = 600000;
const bulkCreatePrebuiltSavedObjects = async ({
  share,
  to,
  errorMessage,
  http,
  options,
  renderDashboardLink,
  renderDocLink,
  from,
  startServices: {
    notifications,
    ...startServices
  }
}) => {
  const res = await http.post((0, _constants2.prebuiltSavedObjectsBulkCreateUrl)(options.templateName), {
    version: '1'
  }).then(result => {
    var _response$error;
    const response = result[options.templateName];
    const error = response === null || response === void 0 ? void 0 : (_response$error = response.error) === null || _response$error === void 0 ? void 0 : _response$error.message;
    if (error) {
      notifications.toasts.addError(new Error(errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.IMPORT_SAVED_OBJECTS_FAILURE), {
        title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.IMPORT_SAVED_OBJECTS_FAILURE,
        toastMessage: renderDocLink ? renderDocLink(error) : error,
        toastLifeTimeMs
      });
    } else {
      var _response$body, _response$body2, _response$body3, _response$body4;
      const dashboardTitle = options.templateName === `${_search_strategy.EntityType.user}RiskScoreDashboards` ? _constants.RISKY_USERS_DASHBOARD_TITLE : _constants.RISKY_HOSTS_DASHBOARD_TITLE;
      const targetDashboard = response === null || response === void 0 ? void 0 : (_response$body = response.body) === null || _response$body === void 0 ? void 0 : _response$body.find(obj => obj.type === 'dashboard' && (obj === null || obj === void 0 ? void 0 : obj.title) === dashboardTitle);
      let targetUrl;
      if (targetDashboard !== null && targetDashboard !== void 0 && targetDashboard.id) {
        var _share$url$locators$g;
        targetUrl = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR)) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.getRedirectUrl({
          dashboardId: targetDashboard === null || targetDashboard === void 0 ? void 0 : targetDashboard.id,
          timeRange: {
            to,
            from
          }
        });
      }
      const successMessage = response === null || response === void 0 ? void 0 : (_response$body2 = response.body) === null || _response$body2 === void 0 ? void 0 : _response$body2.map(o => {
        var _o$title;
        return (_o$title = o === null || o === void 0 ? void 0 : o.title) !== null && _o$title !== void 0 ? _o$title : o === null || o === void 0 ? void 0 : o.name;
      }).join(', ');
      if (successMessage == null || (response === null || response === void 0 ? void 0 : (_response$body3 = response.body) === null || _response$body3 === void 0 ? void 0 : _response$body3.length) == null) {
        return;
      }
      notifications.toasts.addSuccess({
        'data-test-subj': `${options.templateName}SuccessToast`,
        title: (0, _translations.IMPORT_SAVED_OBJECTS_SUCCESS)(response === null || response === void 0 ? void 0 : (_response$body4 = response.body) === null || _response$body4 === void 0 ? void 0 : _response$body4.length),
        text: (0, _reactKibanaMount.toMountPoint)(renderDashboardLink && targetUrl ? renderDashboardLink(successMessage, targetUrl) : successMessage, startServices),
        toastLifeTimeMs
      });
    }
  }).catch(e => {
    var _e$body, _e$body2;
    notifications.toasts.addError(new Error(errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.IMPORT_SAVED_OBJECTS_FAILURE), {
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.IMPORT_SAVED_OBJECTS_FAILURE,
      toastMessage: renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) : e === null || e === void 0 ? void 0 : (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message,
      toastLifeTimeMs
    });
  });
  return res;
};
exports.bulkCreatePrebuiltSavedObjects = bulkCreatePrebuiltSavedObjects;
const bulkDeletePrebuiltSavedObjects = async ({
  http,
  errorMessage,
  options,
  startServices: {
    notifications
  }
}) => {
  const res = await http.post((0, _constants2.prebuiltSavedObjectsBulkDeleteUrl)(options.templateName), {
    version: '1'
  }).catch(e => {
    var _e$body3;
    notifications.toasts.addDanger({
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.DELETE_SAVED_OBJECTS_FAILURE,
      text: e === null || e === void 0 ? void 0 : (_e$body3 = e.body) === null || _e$body3 === void 0 ? void 0 : _e$body3.message
    });
  });
  return res;
};
exports.bulkDeletePrebuiltSavedObjects = bulkDeletePrebuiltSavedObjects;