"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RISK_INFO_BUTTON_CLASS = exports.RiskInformationFlyout = exports.RiskInformationButtonEmpty = exports.HOST_RISK_INFO_BUTTON_CLASS = void 0;
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _helper_hooks = require("../../../helper_hooks");
var _common = require("../severity/common");
var _search_strategy = require("../../../../common/search_strategy");
var _asset_criticality = require("../../../../common/entity_analytics/asset_criticality");
var _entity_analytics_doc_link = require("../risk_score_onboarding/entity_analytics_doc_link");
var _asset_criticality2 = require("../asset_criticality");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SpacedOrderedList = _styled.default.ol`
  li {
    margin-bottom: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
  }
`;
const getRiskLevelTableColumns = () => [{
  field: 'level',
  name: i18n.INFORMATION_LEVEL_HEADER,
  render: riskScore => {
    if (riskScore != null) {
      return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: riskScore,
        hideBackgroundColor: true
      });
    }
  }
}, {
  field: 'range',
  name: i18n.INFORMATION_RISK_HEADER
}];
const riskLevelTableItems = [{
  level: _search_strategy.RiskSeverity.Critical,
  range: i18n.CRITICAL_RISK_DESCRIPTION
}, {
  level: _search_strategy.RiskSeverity.High,
  range: '70 - 90 '
}, {
  level: _search_strategy.RiskSeverity.Moderate,
  range: '40 - 70'
}, {
  level: _search_strategy.RiskSeverity.Low,
  range: '20 - 40'
}, {
  level: _search_strategy.RiskSeverity.Unknown,
  range: i18n.UNKNOWN_RISK_DESCRIPTION
}];
const criticalityLevelTableItems = [_asset_criticality.CriticalityLevels.EXTREME_IMPACT, _asset_criticality.CriticalityLevels.HIGH_IMPACT, _asset_criticality.CriticalityLevels.MEDIUM_IMPACT, _asset_criticality.CriticalityLevels.LOW_IMPACT].map(level => ({
  level,
  weight: _asset_criticality.CriticalityModifiers[level]
}));
const getCriticalityLevelTableColumns = () => [{
  field: 'level',
  name: i18n.INFORMATION_TIER_HEADER,
  render: level => /*#__PURE__*/_react.default.createElement(_asset_criticality2.AssetCriticalityBadge, {
    criticalityLevel: level
  })
}, {
  field: 'weight',
  name: i18n.INFORMATION_WEIGHT_HEADER
}];
const HOST_RISK_INFO_BUTTON_CLASS = exports.HOST_RISK_INFO_BUTTON_CLASS = 'HostRiskInformation__button';
const USER_RISK_INFO_BUTTON_CLASS = exports.USER_RISK_INFO_BUTTON_CLASS = 'UserRiskInformation__button';
const RiskInformationButtonEmpty = ({
  riskEntity
}) => {
  const [isFlyoutVisible, handleOnOpen, handleOnClose] = (0, _helper_hooks.useOnOpenCloseHandler)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleOnOpen,
    "data-test-subj": "open-risk-information-flyout-trigger"
  }, i18n.INFO_BUTTON_TEXT), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(RiskInformationFlyout, {
    handleOnClose: handleOnClose
  }));
};
exports.RiskInformationButtonEmpty = RiskInformationButtonEmpty;
const RiskInformationFlyout = ({
  handleOnClose
}) => {
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'RiskInformation'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: handleOnClose,
    "aria-labelledby": simpleFlyoutTitleId,
    size: 450,
    "data-test-subj": "open-risk-information-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, i18n.TITLE))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.introText",
    defaultMessage: "Entity Risk Analytics surfaces risky hosts and users from within your environment."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskScoreFieldText",
    defaultMessage: "The {riskScoreField} field represents the normalized risk of the Entity as a single numeric value. You can use this value as a relative indicator of risk in triaging and response playbooks.",
    values: {
      riskScoreField: /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskInformation.riskScoreFieldLabel",
        defaultMessage: "Entity risk score"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskScoreLevelText",
    defaultMessage: "The {riskLevelField} field represents the risk level of the Entity based on set of predefined risk metrics.",
    values: {
      riskLevelField: /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskInformation.riskScoreLevelLabel",
        defaultMessage: "Entity risk level"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.howOftenTitle",
    defaultMessage: "How often is risk calculated?"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.howOftenText",
    defaultMessage: "Once enabled, entity risk scoring runs hourly."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.howCalculatedTitle",
    defaultMessage: "How is risk calculated?"
  }))), /*#__PURE__*/_react.default.createElement(SpacedOrderedList, null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskCalculationStep1",
    defaultMessage: "Only scores users and hosts (entities) associated with detection alerts that have not been closed."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskCalculationStep2",
    defaultMessage: "Generates an 'Alert' category score by aggregating alerts by entity idenfifier such that alerts with higher risk scores contribute more than alerts with lower risk scores."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskCalculationStep3",
    defaultMessage: "If the 'Asset Criticality' feature is enabled in your space, entity risk scoring verifies the asset criticality classification tier of the entity and generates a score modifier under the 'Asset Criticality' category."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: getCriticalityLevelTableColumns(),
    items: criticalityLevelTableItems,
    "data-test-subj": "criticality-level-information-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskCalculationStep4",
    defaultMessage: "Produces entity risk as a normalized numeric score."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskInformation.riskCalculationStep5",
    defaultMessage: "Maps the entity risk label based on the normalized risk score."
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: getRiskLevelTableColumns(),
    items: riskLevelTableItems,
    "data-test-subj": "risk-level-information-table"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_entity_analytics_doc_link.EntityAnalyticsLearnMoreLink, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleOnClose
  }, i18n.CLOSE_BUTTON_TEXT)))));
};
exports.RiskInformationFlyout = RiskInformationFlyout;