"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntitiesListFilters = void 0;
var _react = require("react");
var _constants = require("../../../../../common/constants");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
var _types = require("../types");
var _use_enabled_entity_types = require("../../../hooks/use_enabled_entity_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntitiesListFilters = ({
  selectedSeverities,
  selectedCriticalities,
  selectedSources
}) => {
  const {
    filterQuery: globalQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const enabledEntityTypes = (0, _use_enabled_entity_types.useStoreEntityTypes)();
  return (0, _react.useMemo)(() => {
    const criticalityFilter = selectedCriticalities.length ? [{
      bool: {
        should: selectedCriticalities.map(value => ({
          term: {
            'asset.criticality': value
          }
        }))
      }
    }] : [];
    const sourceFilter = selectedSources.length ? [{
      bool: {
        should: selectedSources.map(tag => getSourceTagFilterQuery(tag))
      }
    }] : [];
    const severityFilter = selectedSeverities.length ? [{
      bool: {
        should: enabledEntityTypes.map(type => ({
          terms: {
            [_search_strategy.EntityTypeToLevelField[type]]: selectedSeverities
          }
        }))
      }
    }] : [];
    const filterList = [...severityFilter, ...criticalityFilter, ...sourceFilter];
    if (globalQuery) {
      filterList.push(globalQuery);
    }
    return filterList;
  }, [enabledEntityTypes, globalQuery, selectedCriticalities, selectedSeverities, selectedSources]);
};
exports.useEntitiesListFilters = useEntitiesListFilters;
const getSourceTagFilterQuery = tag => {
  if (tag === _types.EntitySourceTag.risk) {
    return {
      wildcard: {
        'entity.source': _constants.RISK_SCORE_INDEX_PATTERN
      }
    };
  }
  if (tag === _types.EntitySourceTag.criticality) {
    return {
      wildcard: {
        'entity.source': _constants.ASSET_CRITICALITY_INDEX_PATTERN
      }
    };
  }
  return {
    bool: {
      must_not: [{
        wildcard: {
          'entity.source': _constants.ASSET_CRITICALITY_INDEX_PATTERN
        }
      }, {
        wildcard: {
          'entity.source': _constants.RISK_SCORE_INDEX_PATTERN
        }
      }]
    }
  };
};